/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.StatusLine;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.LifecycleManager;
import org.openide.awt.MenuBar;
import org.openide.awt.StatusLineElementProvider;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    private static JMenuBar mainMenuBar;
    private Component desktop;
    private JPanel desktopPanel;
    private static JPanel innerIconsPanel;
    private boolean inited;
    private Lookup.Result<SaveCookie> saveResult;
    private Lookup.Result<DataObject> dobResult;
    private LookupListener saveListener;
    private static Lookup.Result<StatusLineElementProvider> result;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private Rectangle forcedBounds = null;
    private boolean isFullScreenMode = false;
    private Rectangle restoreBounds;
    private int restoreExtendedState = 0;
    private boolean isSwitchingFullScreenMode = false;
    private boolean isUndecorated = true;
    private int windowDecorationStyle = 1;

    public MainWindow() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID()) && null == System.getProperty("apple.awt.brushMetalLook")) {
            this.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        }
    }

    @Override
    protected void setRootPane(JRootPane root) {
        super.setRootPane(root);
        if (root != null) {
            HelpCtx.setHelpIDString((JComponent)root, (String)new HelpCtx(MainWindow.class).getHelpID());
        }
        root.setOpaque(true);
        if (Utilities.isWindows()) {
            JPanel c = new JPanel(){

                @Override
                public void setVisible(boolean flag) {
                    if (flag != this.isVisible()) {
                        super.setVisible(flag);
                    }
                }
            };
            c.setName(root.getName() + ".nbGlassPane");
            c.setVisible(false);
            ((JPanel)c).setOpaque(false);
            root.setGlassPane(c);
        }
    }

    public static void init() {
        if (mainMenuBar == null) {
            mainMenuBar = MainWindow.createMenuBar();
            ToolbarPool.getDefault().waitFinished();
        }
    }

    public void initializeComponents() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        MainWindow.init();
        MainWindow.initFrameIcons(this);
        this.initListeners();
        this.setDefaultCloseOperation(0);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainWindow.class).getString("ACSD_MainWindow"));
        this.setJMenuBar(mainMenuBar);
        if (!Constants.NO_TOOLBARS) {
            JComponent tb = MainWindow.getToolbarComponent();
            this.getContentPane().add((Component)tb, "North");
        }
        if (!Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            JComponent status;
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                status = new StatusLine();
                ((JLabel)status).setText(" ");
                status.setPreferredSize(new Dimension(0, status.getPreferredSize().height));
                status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                JPanel statusLinePanel = new JPanel(new BorderLayout());
                int magicConstant = 0;
                if (Utilities.isMac()) {
                    magicConstant = 12;
                    if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                        statusLinePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.darkShadow")), BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.lightShadow"))));
                    }
                }
                statusLinePanel.setBorder(BorderFactory.createCompoundBorder(statusLinePanel.getBorder(), BorderFactory.createEmptyBorder(0, 0, 0, magicConstant)));
                statusLinePanel.add((Component)new JSeparator(), "North");
                statusLinePanel.add((Component)status, "Center");
                MainWindow.decoratePanel(statusLinePanel, false);
                statusLinePanel.setName("statusLine");
                this.getContentPane().add((Component)statusLinePanel, "South");
            } else {
                status = MainWindow.getCustomStatusLine();
                if (status != null) {
                    this.getContentPane().add((Component)status, "South");
                }
            }
        }
        this.getContentPane().add((Component)this.getDesktopPanel(), "Center");
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MenuElement[] elems = MenuSelectionManager.defaultManager().getSelectedPath();
                if (elems != null && elems.length > 0 && elems[0] == MainWindow.this.getJMenuBar() && !MainWindow.this.isActive()) {
                    MainWindow.this.toFront();
                }
            }
        });
        this.setTitle(NbBundle.getMessage(MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)System.getProperty("netbeans.buildnumber")));
        if (Utilities.getOperatingSystem() == 4096) {
            this.saveResult = Utilities.actionsGlobalContext().lookupResult(SaveCookie.class);
            this.dobResult = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
            if (null != this.saveResult && null != this.dobResult) {
                this.saveListener = new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        if (ev.getSource() == MainWindow.this.saveResult) {
                            boolean modified = MainWindow.this.saveResult.allItems().size() > 0;
                            MainWindow.this.getRootPane().putClientProperty("Window.documentModified", modified ? Boolean.TRUE : Boolean.FALSE);
                        } else if (ev.getSource() == MainWindow.this.dobResult) {
                            int count = MainWindow.this.dobResult.allItems().size();
                            switch (count) {
                                case 1: {
                                    DataObject dob = (DataObject)MainWindow.this.dobResult.allInstances().iterator().next();
                                    FileObject file = dob.getPrimaryFile();
                                    File f = FileUtil.toFile((FileObject)file);
                                    if (f != null) {
                                        MainWindow.this.getRootPane().putClientProperty("Window.documentFile", f);
                                        break;
                                    }
                                }
                                default: {
                                    MainWindow.this.getRootPane().putClientProperty("Window.documentFile", null);
                                }
                            }
                        }
                    }
                };
                this.saveResult.addLookupListener(this.saveListener);
                this.dobResult.addLookupListener(this.saveListener);
            }
        }
    }

    private static void decoratePanel(JPanel panel, boolean safeAccess) {
        assert (safeAccess || SwingUtilities.isEventDispatchThread()) : "Must run in AWT queue.";
        if (innerIconsPanel != null) {
            panel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = MainWindow.getStatusLineElements(panel)) != null) {
            panel.add((Component)innerIconsPanel, "East");
        }
    }

    static JPanel getStatusLineElements(JPanel panel) {
        Collection c;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(panel));
        }
        if ((c = result.allInstances()) == null || c.isEmpty()) {
            return null;
        }
        Iterator it = c.iterator();
        JPanel icons = new JPanel(new FlowLayout(2, 0, 0));
        icons.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        boolean some = false;
        while (it.hasNext()) {
            StatusLineElementProvider o = (StatusLineElementProvider)it.next();
            Component comp = o.getStatusLineElement();
            if (comp == null) continue;
            some = true;
            icons.add(comp);
        }
        return some ? icons : null;
    }

    private static Border getDesktopBorder() {
        Border b = (Border)UIManager.get("nb.desktop.splitpane.border");
        if (b != null) {
            return b;
        }
        return new EmptyBorder(1, 1, 1, 1);
    }

    static void initFrameIcons(Frame f) {
        f.setIconImages(Arrays.asList(ImageUtilities.loadImage((String)ICON_16, (boolean)true), ImageUtilities.loadImage((String)ICON_32, (boolean)true), ImageUtilities.loadImage((String)ICON_48, (boolean)true)));
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LifecycleManager.getDefault().exit();
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                RegistryImpl.cancelMenu(MainWindow.this);
            }
        });
    }

    private static JMenuBar createMenuBar() {
        JMenuBar menu = MainWindow.getCustomMenuBar();
        if (menu == null) {
            menu = new MenuBar(null);
        }
        menu.setBorderPainted(false);
        if (menu instanceof MenuBar) {
            ((MenuBar)menu).waitFinished();
        }
        if (Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                StatusLine status = new StatusLine();
                JSeparator sep = new JSeparator(1);
                Dimension d = sep.getPreferredSize();
                d.width += 6;
                sep.setPreferredSize(d);
                JPanel statusLinePanel = new JPanel(new BorderLayout());
                statusLinePanel.add((Component)sep, "West");
                statusLinePanel.add((Component)status, "Center");
                MainWindow.decoratePanel(statusLinePanel, true);
                statusLinePanel.setName("statusLine");
                menu.add(statusLinePanel);
            } else {
                JComponent status = MainWindow.getCustomStatusLine();
                if (status != null) {
                    menu.add(status);
                }
            }
        }
        return menu;
    }

    private static JMenuBar getCustomMenuBar() {
        try {
            DataObject dobj;
            InstanceCookie ic;
            String fileName = Constants.CUSTOM_MENU_BAR_PATH;
            if (fileName == null) {
                return null;
            }
            FileObject fo = FileUtil.getConfigFile((String)fileName);
            if (fo != null && (ic = (InstanceCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(InstanceCookie.class)) != null) {
                return (JMenuBar)ic.instanceCreate();
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static JComponent getCustomStatusLine() {
        try {
            DataObject dobj;
            InstanceCookie ic;
            String fileName = Constants.CUSTOM_STATUS_LINE_PATH;
            if (fileName == null) {
                return null;
            }
            FileObject fo = FileUtil.getConfigFile((String)fileName);
            if (fo != null && (ic = (InstanceCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(InstanceCookie.class)) != null) {
                return (JComponent)ic.instanceCreate();
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static JComponent getToolbarComponent() {
        ToolbarPool tp = ToolbarPool.getDefault();
        tp.waitFinished();
        return tp;
    }

    private void initializeBounds() {
        Rectangle bounds = WindowManagerImpl.getInstance().getEditorAreaState() == 0 ? WindowManagerImpl.getInstance().getMainWindowBoundsJoined() : WindowManagerImpl.getInstance().getMainWindowBoundsSeparated();
        if (null != this.forcedBounds) {
            bounds = new Rectangle(this.forcedBounds);
            this.setPreferredSize(bounds.getSize());
            this.forcedBounds = null;
        }
        if (!bounds.isEmpty()) {
            this.setBounds(bounds);
        }
    }

    public void prepareWindow() {
        this.initializeBounds();
    }

    public void setDesktop(Component comp) {
        if (this.desktop == comp) {
            if (this.desktop != null && !Arrays.asList(this.getDesktopPanel().getComponents()).contains(this.desktop)) {
                this.getDesktopPanel().add(this.desktop, "Center");
            }
            return;
        }
        if (this.desktop != null) {
            this.getDesktopPanel().remove(this.desktop);
        }
        this.desktop = comp;
        if (this.desktop != null) {
            this.getDesktopPanel().add(this.desktop, "Center");
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Component getDesktop() {
        return this.desktop;
    }

    public boolean hasDesktop() {
        return this.desktop != null;
    }

    private JPanel getDesktopPanel() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new JPanel();
            this.desktopPanel.setBorder(MainWindow.getDesktopBorder());
            this.desktopPanel.setLayout(new BorderLayout());
        }
        return this.desktopPanel;
    }

    public Rectangle getPureMainWindowBounds() {
        Rectangle bounds = this.getBounds();
        if (this.desktop != null) {
            Dimension desktopSize = this.desktop.getSize();
            bounds.height -= desktopSize.height;
        }
        return bounds;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Logger.getLogger(MainWindow.class.getName()).log(Level.FINE, "Paint method of main window invoked normally.");
        WindowManagerImpl.getInstance().mainWindowPainted();
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        GraphicsConfiguration conf;
        ToolbarConfiguration tc;
        if (this.isFullScreenMode == fullScreenMode || this.isSwitchingFullScreenMode) {
            return;
        }
        this.isSwitchingFullScreenMode = true;
        if (!this.isFullScreenMode) {
            this.restoreExtendedState = this.getExtendedState();
            this.restoreBounds = this.getBounds();
            this.isUndecorated = this.isUndecorated();
            this.windowDecorationStyle = this.getRootPane().getWindowDecorationStyle();
        }
        this.isFullScreenMode = fullScreenMode;
        if (Utilities.isWindows()) {
            this.setVisible(false);
        } else {
            WindowManagerImpl.getInstance().setVisible(false);
        }
        this.dispose();
        this.setUndecorated(this.isFullScreenMode || this.isUndecorated);
        this.getRootPane().setWindowDecorationStyle(this.isFullScreenMode ? 0 : this.windowDecorationStyle);
        final String toolbarConfigName = ToolbarPool.getDefault().getConfiguration();
        if (null != toolbarConfigName && null != (tc = ToolbarConfiguration.findConfiguration(toolbarConfigName))) {
            tc.rebuildMenu();
        }
        MainWindow.getToolbarComponent().setVisible(!this.isFullScreenMode);
        final boolean updateBounds = !this.isFullScreenMode;
        GraphicsDevice device = null;
        Graphics gc = this.getGraphics();
        if (gc instanceof Graphics2D && null != (conf = ((Graphics2D)gc).getDeviceConfiguration())) {
            device = conf.getDevice();
        }
        if (null != device && device.isFullScreenSupported()) {
            device.setFullScreenWindow(this.isFullScreenMode ? this : null);
        } else {
            this.setExtendedState(this.isFullScreenMode ? 6 : this.restoreExtendedState);
        }
        if (updateBounds || this.isFullScreenMode() && !Utilities.isWindows()) {
            if (updateBounds) {
                this.forcedBounds = this.restoreBounds;
            } else {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.forcedBounds = ge.getMaximumWindowBounds();
            }
        }
        if (Utilities.isWindows()) {
            this.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                    if (updateBounds) {
                        MainWindow.this.setPreferredSize(MainWindow.this.restoreBounds.getSize());
                        MainWindow.this.setBounds(MainWindow.this.restoreBounds);
                    }
                    ToolbarPool.getDefault().setConfiguration(toolbarConfigName);
                    MainWindow.this.isSwitchingFullScreenMode = false;
                }
            });
        } else {
            WindowManagerImpl.getInstance().setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                    ToolbarPool.getDefault().setConfiguration(toolbarConfigName);
                    MainWindow.this.isSwitchingFullScreenMode = false;
                }
            });
        }
    }

    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    private static class HeavyWeightPopup
    extends Popup {
        public HeavyWeightPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
        }
    }

    private static class HeavyWeightPopupFactory
    extends PopupFactory {
        private HeavyWeightPopupFactory() {
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
            return new HeavyWeightPopup(owner, contents, x, y);
        }
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel decoratingPanel) {
            this.decoratingPanel = decoratingPanel;
        }

        public void resultChanged(LookupEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.decoratePanel(StatusLineElementsListener.this.decoratingPanel, false);
                }
            });
        }
    }
}

