/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;

class IncludedModelImpl
implements IncludedModel {
    private Map<CsmFile, Set<CsmFile>> map;
    private Action[] actions;
    private Action close;
    private boolean direction;

    public IncludedModelImpl(CsmFile file, Action[] actions, boolean whoIncludes, boolean plain, boolean recursive) {
        Set<CsmFile> result;
        this.actions = actions;
        this.direction = whoIncludes;
        this.map = whoIncludes ? this.buildWhoIncludes(file) : this.buildWhoIsIncluded(file);
        if (!recursive) {
            result = this.map.get(file);
            if (result == null) {
                result = new HashSet<CsmFile>();
            }
            this.map = new HashMap<CsmFile, Set<CsmFile>>();
            this.map.put(file, result);
        }
        if (plain) {
            result = new HashSet<CsmFile>();
            this.gatherList(file, result, this.map);
            this.map = new HashMap<CsmFile, Set<CsmFile>>();
            this.map.put(file, result);
        }
    }

    private void gatherList(CsmFile file, Set<CsmFile> result, Map<CsmFile, Set<CsmFile>> map) {
        Set<CsmFile> set = map.get(file);
        if (set == null) {
            return;
        }
        for (CsmFile f : set) {
            if (result.contains(f)) continue;
            result.add(f);
            this.gatherList(f, result, map);
        }
    }

    @Override
    public Map<CsmFile, Set<CsmFile>> getModel() {
        return this.map;
    }

    @Override
    public boolean isDownDirection() {
        return !this.direction;
    }

    private Map<CsmFile, Set<CsmFile>> buildWhoIncludes(CsmFile file) {
        HashMap<CsmFile, Set<CsmFile>> aMap = new HashMap<CsmFile, Set<CsmFile>>();
        for (CsmProject prj : CsmModelAccessor.getModel().projects()) {
            for (CsmFile f : prj.getSourceFiles()) {
                this.buildWhoIncludes(f, aMap);
            }
            for (CsmFile f : prj.getHeaderFiles()) {
                this.buildWhoIncludes(f, aMap);
            }
            for (CsmProject lib : prj.getLibraries()) {
                for (CsmFile f : lib.getSourceFiles()) {
                    this.buildWhoIncludes(f, aMap);
                }
                for (CsmFile f : lib.getHeaderFiles()) {
                    this.buildWhoIncludes(f, aMap);
                }
            }
        }
        return aMap;
    }

    private void buildWhoIncludes(CsmFile file, Map<CsmFile, Set<CsmFile>> map) {
        for (CsmInclude include : file.getIncludes()) {
            CsmFile included = include.getIncludeFile();
            if (included == null) continue;
            Set<CsmFile> back = map.get(included);
            if (back == null) {
                back = new HashSet<CsmFile>();
                map.put(included, back);
            }
            if (back.contains(file)) continue;
            back.add(file);
            this.buildWhoIncludes(included, map);
        }
    }

    private Map<CsmFile, Set<CsmFile>> buildWhoIsIncluded(CsmFile file) {
        HashMap<CsmFile, Set<CsmFile>> aMap = new HashMap<CsmFile, Set<CsmFile>>();
        this.buildWhoIsIncluded(file, aMap);
        return aMap;
    }

    private void buildWhoIsIncluded(CsmFile file, Map<CsmFile, Set<CsmFile>> map) {
        Set<CsmFile> includes = map.get(file);
        if (includes != null) {
            return;
        }
        includes = new HashSet<CsmFile>();
        map.put(file, includes);
        for (CsmInclude include : file.getIncludes()) {
            CsmFile included = include.getIncludeFile();
            if (included == null) continue;
            includes.add(included);
            this.buildWhoIsIncluded(included, map);
        }
    }

    @Override
    public Action[] getDefaultActions() {
        return this.actions;
    }

    @Override
    public Action getCloseWindowAction() {
        return this.close;
    }

    @Override
    public void setCloseWindowAction(Action close) {
        this.close = close;
    }
}

