/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.wizards.SpringXMLConfigGroupPanel;
import org.netbeans.modules.spring.beans.wizards.SpringXMLConfigNamespacesPanel;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class NewSpringXMLConfigWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            ConfigFileManager configFileManager = NewSpringXMLConfigWizardIterator.getConfigFileManager(project);
            List<ConfigFileGroup> list = configFileManager != null ? configFileManager.getConfigFileGroups() : null;
            SpringXMLConfigGroupPanel springXMLConfigGroupPanel = list != null && !list.isEmpty() ? new SpringXMLConfigGroupPanel(list) : null;
            WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)springXMLConfigGroupPanel);
            this.panels = new WizardDescriptor.Panel[]{panel, new SpringXMLConfigNamespacesPanel()};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        FileObject fileObject;
        FileObject fileObject2;
        ClassPath classPath;
        Object object;
        FileObject fileObject3 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject[] fileObjectArray = new FileObject[]{null};
        String string2 = "";
        boolean bl = (Boolean)this.wizard.getProperty("addSpringToClassPath");
        if (bl) {
            object = new Library[]{(Library)this.wizard.getProperty("springLibrary")};
            string2 = SpringUtilities.getSpringLibraryVersion(object[0]);
            this.addLibrariesToClassPath((Library[])object);
        } else {
            object = NewSpringXMLConfigWizardIterator.getSourceGroupArtifact(Templates.getProject((WizardDescriptor)this.wizard), fileObject3);
            classPath = ClassPath.getClassPath((FileObject)object, (String)"classpath/compile");
            fileObject2 = null;
            if (classPath != null) {
                fileObject2 = classPath.findResource("org.springframework.core.SpringVersion".replace('.', '/') + ".class");
            }
            if (fileObject2 != null) {
                fileObject = classPath.findOwnerRoot(fileObject2);
                string2 = this.findSpringVersion(fileObject);
            }
        }
        if (string2 == null || "".equals(string2)) {
            string2 = "2.5";
        }
        object = new HashMap();
        if (string2.startsWith("3.0")) {
            string2 = "3.0";
            ((HashMap)object).put("springVersion3", Boolean.TRUE);
        }
        ((HashMap)object).put("namespaces", this.getNamespacesList(string2));
        classPath = DataFolder.findFolder((FileObject)fileObject3);
        fileObject2 = Templates.getTemplate((WizardDescriptor)this.wizard);
        fileObject = DataObject.find((FileObject)fileObject2);
        fileObjectArray[0] = fileObject.createFromTemplate((DataFolder)classPath, string, (Map)object).getPrimaryFile();
        Set<ConfigFileGroup> set = (Set<ConfigFileGroup>)this.wizard.getProperty("configFileGroups");
        this.addFileToConfigFileManager(set != null ? set : Collections.emptySet(), FileUtil.toFile((FileObject)fileObjectArray[0]));
        return Collections.singleton(fileObjectArray[0]);
    }

    private List<TemplateData> getNamespacesList(String string) {
        String[] stringArray;
        ArrayList<TemplateData> arrayList = new ArrayList<TemplateData>();
        for (String string2 : stringArray = (String[])this.wizard.getProperty("includedNamespaces")) {
            String string3 = string2.substring(0, string2.indexOf("-")).trim();
            String string4 = string2.substring(string2.indexOf("-") + 1).trim();
            String string5 = string4.equals("http://www.springframework.org/schema/webflow-config") ? "spring-" + string4.substring(string4.lastIndexOf("/") + 1) + "-2.0.xsd" : "spring-" + string4.substring(string4.lastIndexOf("/") + 1) + "-" + string + ".xsd";
            arrayList.add(new TemplateData(string3, string4, string5));
        }
        return arrayList;
    }

    private String findSpringVersion(FileObject fileObject) {
        try {
            if (fileObject != null && fileObject.getFileSystem() instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)fileObject.getFileSystem();
                return SpringUtilities.getImplementationVersion(jarFileSystem);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    private void addLibrariesToClassPath(Library[] libraryArray) throws IOException {
        FileObject fileObject = NewSpringXMLConfigWizardIterator.getSourceGroupArtifact(Templates.getProject((WizardDescriptor)this.wizard), Templates.getTargetFolder((WizardDescriptor)this.wizard));
        if (fileObject != null) {
            ProjectClassPathModifier.addLibraries((Library[])libraryArray, (FileObject)fileObject, (String)"classpath/compile");
        }
    }

    private void addFileToConfigFileManager(final Set<ConfigFileGroup> set, final File file) throws IOException {
        final ConfigFileManager configFileManager = NewSpringXMLConfigWizardIterator.getConfigFileManager(Templates.getProject((WizardDescriptor)this.wizard));
        try {
            configFileManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    List<File> list = configFileManager.getConfigFiles();
                    ArrayList<File> arrayList = new ArrayList<File>(list);
                    if (!arrayList.contains(file)) {
                        arrayList.add(file);
                    }
                    List<ConfigFileGroup> list2 = configFileManager.getConfigFileGroups();
                    List<ConfigFileGroup> list3 = null;
                    if (set.size() > 0) {
                        list3 = new ArrayList<ConfigFileGroup>(list2.size());
                        for (ConfigFileGroup configFileGroup : list2) {
                            if (set.contains(configFileGroup)) {
                                ConfigFileGroup configFileGroup2 = NewSpringXMLConfigWizardIterator.this.addFileToConfigGroup(configFileGroup, file);
                                list3.add(configFileGroup2);
                                continue;
                            }
                            list3.add(configFileGroup);
                        }
                    } else {
                        list3 = list2;
                    }
                    configFileManager.putConfigFilesAndGroups(arrayList, list3);
                    configFileManager.save();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private ConfigFileGroup addFileToConfigGroup(ConfigFileGroup configFileGroup, File file) {
        List<File> list = configFileGroup.getFiles();
        list.add(file);
        return ConfigFileGroup.create(configFileGroup.getName(), list);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            FileObject fileObject;
            Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            SpringConfigFileLocationProvider springConfigFileLocationProvider = project != null ? (SpringConfigFileLocationProvider)project.getLookup().lookup(SpringConfigFileLocationProvider.class) : null;
            FileObject fileObject2 = fileObject = springConfigFileLocationProvider != null ? springConfigFileLocationProvider.getLocation() : null;
            if (fileObject != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)fileObject);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    static ConfigFileManager getConfigFileManager(Project project) {
        ProjectSpringScopeProvider projectSpringScopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        return projectSpringScopeProvider != null ? projectSpringScopeProvider.getSpringScope().getConfigFileManager() : null;
    }

    static FileObject getSourceGroupArtifact(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project)) {
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (!fileObject.equals(fileObject2) && (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || !sourceGroup.contains(fileObject))) continue;
            return fileObject;
        }
        int n = 0;
        SourceGroup[] sourceGroupArray2 = sourceGroupArray;
        int n2 = sourceGroupArray2.length;
        if (n < n2) {
            SourceGroup sourceGroup;
            sourceGroup = sourceGroupArray2[n];
            return sourceGroup.getRootFolder();
        }
        return null;
    }

    public static final class TemplateData {
        private String prefix;
        private String namespace;
        private String fileName;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String string) {
            this.namespace = string;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public TemplateData(String string, String string2, String string3) {
            this.prefix = string;
            this.namespace = string2;
            this.fileName = string3;
        }
    }
}

