/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PreprocessorActions {
    public static final String generatePreprocessorPopupAction = "generate-preprocessor-popup";
    public static final String PROJECT_CLIENT_PROPERTY = "projoject-client-property";

    protected static JMenu createMenu(JMenu menu, JTextComponent c) {
        String menuText = NbBundle.getMessage(PreprocessorActions.class, (String)"Menu/Edit/PreprocessorBlocks");
        if (menu == null) {
            menu = new JMenu();
        } else {
            menu.removeAll();
        }
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)menuText);
        BaseKit kit = Utilities.getKit((JTextComponent)c);
        if (kit == null) {
            return menu;
        }
        ProjectConfigurationsHelper cfgHelper = null;
        ArrayList lineList = null;
        if (c != null && c.getDocument() != null) {
            cfgHelper = J2MEProjectUtils.getCfgHelperForDoc((Document)c.getDocument());
            lineList = (ArrayList)c.getDocument().getProperty("preprocessor.line.list");
        }
        if (lineList == null) {
            lineList = new ArrayList();
        }
        PreprocessorActions.addAction(kit, cfgHelper, lineList, c, menu, "add-project-configuration-action");
        menu.addSeparator();
        PreprocessorActions.addAction(kit, cfgHelper, lineList, c, menu, "create-if-else-block-action");
        PreprocessorActions.addAction(kit, cfgHelper, lineList, c, menu, "add-elif-block-action");
        PreprocessorActions.addAction(kit, cfgHelper, lineList, c, menu, "create-debug-block-action");
        menu.addSeparator();
        PreprocessorActions.addAction(kit, cfgHelper, lineList, c, menu, RecommentAction.NAME);
        return menu;
    }

    private static void addAction(BaseKit kit, ProjectConfigurationsHelper cfgProvider, ArrayList<PPLine> preprocessorBlockList, JTextComponent target, JMenu menu, String actionName) {
        String itemText;
        Action a = kit.getActionByName(actionName);
        if (a != null && a instanceof PreprocessorEditorContextAction && (itemText = ((PreprocessorEditorContextAction)((Object)a)).getPopupMenuText(cfgProvider, preprocessorBlockList, target)) != null) {
            JMenuItem item = new JMenuItem(itemText);
            item.addActionListener(a);
            MultiKeymap km = kit.getKeymap();
            if (km != null) {
                KeyStroke ks;
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                    item.setAccelerator(ks);
                }
            }
            item.setEnabled(((PreprocessorEditorContextAction)((Object)a)).isEnabled(cfgProvider, preprocessorBlockList, target));
            Object helpID = a.getValue("helpID");
            if (helpID != null && helpID instanceof String) {
                item.putClientProperty("HelpID", helpID);
            }
            menu.add(item);
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
    }

    public static class PreprocessorMenuAction
    extends MainMenuAction {
        private JMenu PREPROCESSOR_MENU;

        public static void addAccelerators(Action a, JMenuItem item, JTextComponent target) {
            MainMenuAction.addAccelerators((Action)a, (JMenuItem)item, (JTextComponent)target);
        }

        public PreprocessorMenuAction() {
            super(false, null);
            this.setMenu();
        }

        protected synchronized void setMenu() {
            this.PREPROCESSOR_MENU = PreprocessorActions.createMenu(this.PREPROCESSOR_MENU, Utilities.getFocusedComponent());
            ActionMap am = this.getContextActionMap();
            Action action = null;
            JMenuItem presenter = this.getMenuPresenter();
            if (am != null) {
                action = am.get(this.getActionName());
                Action presenterAction = presenter.getAction();
                if (presenterAction == null) {
                    if (action != null) {
                        presenter.setAction(action);
                        this.menuInitialized = false;
                    }
                } else if (action != null && !action.equals(presenterAction)) {
                    presenter.setAction(action);
                    this.menuInitialized = false;
                } else if (action == null) {
                    presenter.setEnabled(false);
                }
            }
            if (!this.menuInitialized) {
                Mnemonics.setLocalizedText((AbstractButton)presenter, (String)this.getMenuItemText());
                this.menuInitialized = true;
            }
            presenter.setEnabled(action != null);
        }

        protected String getMenuItemText() {
            return NbBundle.getMessage(PreprocessorActions.class, (String)"Menu/Edit/PreprocessorBlocks");
        }

        public JMenuItem getMenuPresenter() {
            return this.PREPROCESSOR_MENU;
        }

        protected String getActionName() {
            return PreprocessorActions.generatePreprocessorPopupAction;
        }
    }

    public static class GeneratePreprocessorPopupAction
    extends BaseAction {
        public GeneratePreprocessorPopupAction() {
            super(PreprocessorActions.generatePreprocessorPopupAction);
            this.putValue("ShortDescription", NbBundle.getMessage(PreprocessorActions.class, (String)PreprocessorActions.generatePreprocessorPopupAction));
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            return PreprocessorActions.createMenu(null, target);
        }
    }
}

