/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.concurrent;

import net.sf.ehcache.constructs.concurrent.Sync;

public class Mutex
implements Sync {
    protected boolean inUse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            try {
                while (this.inUse) {
                    this.wait();
                }
                this.inUse = true;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            if (!this.inUse) {
                this.inUse = true;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (this.inUse) continue;
                    this.inUse = true;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        this.inUse = false;
        this.notify();
    }
}

