/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadT0;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.apduio.T0ServerOpen;
import com.sun.javacard.apduio.T0ServerState;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.IOException;

class T0ServerClosed
extends T0ServerState {
    protected static T0ServerClosed _instance;

    private T0ServerClosed() {
    }

    static T0ServerClosed instance() {
        if (_instance == null) {
            _instance = new T0ServerClosed();
        }
        return _instance;
    }

    synchronized void sendATR(ServerT0Protocol protocol, byte[] atr) throws IOException, TLP224Exception {
        CadT0 cad = protocol.cad;
        TLP224Message tlp224Msg = protocol.tlp224Msg;
        byte[] msgData = tlp224Msg.getData();
        while (true) {
            cad.receiveTLP224Message(tlp224Msg);
            if (msgData[2] != 110) {
                cad.statusResponse(21);
                continue;
            }
            if (msgData[1] == 4) break;
            cad.statusResponse(3);
        }
        msgData[0] = 96;
        msgData[1] = (byte)(atr.length + 4);
        msgData[2] = 0;
        msgData[3] = 40;
        msgData[4] = 2;
        msgData[5] = (byte)atr.length;
        System.arraycopy(atr, 0, msgData, 6, atr.length);
        msgData[atr.length + 6] = (byte)tlp224Msg.computeLRC(atr.length + 6);
        tlp224Msg.setLength(atr.length + 7);
        cad.sendTLP224Message(tlp224Msg);
        this.changeState(protocol, T0ServerOpen.instance());
    }

    public String toString() {
        return T0ServerState._messages.getString("state.closed");
    }
}

