/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());

    public static boolean waitForURLConnection(URL uRL, int n, int n2) {
        Connect connect = new Connect(uRL, n2);
        Thread thread = new Thread(connect);
        thread.start();
        try {
            thread.join(n);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.FINE, "error", interruptedException);
        }
        if (thread.isAlive()) {
            connect.finishLoop();
            thread.interrupt();
        }
        return connect.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String issueGetRequest(URL uRL) {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "error", iOException);
                }
            }
        }
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> set = Util.getTestSourceGroups(project, sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroupArray) {
            if (set.contains(sourceGroup)) continue;
            arrayList.add(sourceGroup);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(Project project, SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map = Util.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet<SourceGroup> hashSet = new HashSet<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroupArray) {
            hashSet.addAll(Util.getTestTargets(sourceGroup, map));
        }
        return hashSet;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map;
        if (sourceGroupArray.length == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap<FileObject, SourceGroup>(2 * sourceGroupArray.length, 0.5f);
            for (SourceGroup sourceGroup : sourceGroupArray) {
                map.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return map;
    }

    private static List<FileObject> getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.log(Level.FINE, null, new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
        }
        return arrayList;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return new ArrayList<SourceGroup>();
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<FileObject> list = Util.getFileObjects(uRLArray);
        for (FileObject fileObject : list) {
            SourceGroup sourceGroup2 = (SourceGroup)map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    public static Set getTagValues(InputStream inputStream, String string, String string2) throws IOException, SAXException {
        return Util.getTagValues(inputStream, new String[]{string}, string2);
    }

    public static Set getTagValues(InputStream inputStream, String[] stringArray, String string) throws IOException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            TLDVersionHandler tLDVersionHandler = new TLDVersionHandler(stringArray, string);
            xMLReader.setContentHandler(tLDVersionHandler);
            try {
                xMLReader.parse(new InputSource(inputStream));
            }
            catch (SAXException sAXException) {
                LOG.log(Level.FINE, "error", sAXException);
            }
            return tLDVersionHandler.getValues();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return new HashSet();
        }
    }

    private static class TLDVersionHandler
    extends DefaultHandler {
        private String tagName;
        private Set<String> elNames = new HashSet<String>();
        private Set<String> values;
        private boolean insideEl;
        private boolean insideTag;

        TLDVersionHandler(String[] stringArray, String string) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.elNames.add(stringArray[i]);
            }
            this.tagName = string;
            this.values = new HashSet<String>();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.elNames.contains(string3)) {
                this.insideEl = true;
            } else if (this.tagName.equals(string3) && this.insideEl) {
                this.insideTag = true;
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.elNames.contains(string3)) {
                this.insideEl = false;
            } else if (this.tagName.equals(string3) && this.insideEl) {
                this.insideTag = false;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.insideTag) {
                this.values.add(String.valueOf(cArray, n, n2).trim());
            }
        }

        public Set getValues() {
            return this.values;
        }
    }

    private static class Connect
    implements Runnable {
        URL url = null;
        int retryTime;
        boolean status = false;
        boolean loop = true;

        public Connect(URL uRL, int n) {
            this.url = uRL;
            this.retryTime = n;
        }

        public void finishLoop() {
            this.loop = false;
        }

        @Override
        public void run() {
            try {
                InetAddress.getByName(this.url.getHost());
            }
            catch (UnknownHostException unknownHostException) {
                LOG.log(Level.FINE, "error", unknownHostException);
                return;
            }
            while (this.loop) {
                try {
                    Socket socket = new Socket(this.url.getHost(), this.url.getPort());
                    socket.close();
                    this.status = true;
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                    LOG.log(Level.FINE, "error", unknownHostException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "error", iOException);
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.FINE, "error", interruptedException);
                }
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }
}

