/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.startup.HostConfig;
import org.apache.tomcat.task.ApacheConfig;
import org.apache.tomcat.task.IISConfig;
import org.apache.tomcat.task.NSConfig;
import org.apache.tomcat.task.StopTomcat;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

public class Tomcat {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.resources");
    String configFile = null;
    static final String DEFAULT_CONFIG = "conf/server.xml";
    boolean doStop = false;

    Tomcat() {
    }

    public void execute(String[] args) throws Exception {
        if (!this.processArgs(args)) {
            return;
        }
        if (this.doStop) {
            System.out.println(sm.getString("tomcat.stop"));
            this.stopTomcat();
            return;
        }
        XmlMapper xh = new XmlMapper();
        xh.setDebug(0);
        ContextManager cm = new ContextManager();
        this.setHelper(xh);
        this.setConnectorHelper(xh);
        this.setLogHelper(xh);
        File f = this.getConfigFile(cm);
        try {
            xh.readXml(f, (Object)cm);
        }
        catch (Exception ex) {
            System.out.println(sm.getString("tomcat.fatalconfigerror"));
            ex.printStackTrace();
            System.exit(1);
        }
        System.out.println(sm.getString("tomcat.start"));
        cm.init();
        Tomcat.generateServerConfig(cm);
        cm.start();
    }

    public static void generateServerConfig(ContextManager cm) throws TomcatException {
        ApacheConfig apacheConfig = new ApacheConfig();
        apacheConfig.execute(cm);
        IISConfig iisConfig = new IISConfig();
        iisConfig.execute(cm);
        NSConfig nsConfig = new NSConfig();
        nsConfig.execute(cm);
    }

    File getConfigFile(ContextManager cm) {
        if (this.configFile != null) {
            return new File(this.configFile);
        }
        String tchome = System.getProperty("tomcat.home");
        if (tchome == null) {
            System.out.println(sm.getString("tomcat.nohome"));
            tchome = ".";
        }
        cm.setInstallDir(tchome);
        return new File(tchome, DEFAULT_CONFIG);
    }

    public static void main(String[] args) {
        try {
            Tomcat tomcat = new Tomcat();
            tomcat.execute(args);
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(sm.getString("tomcat.fatal")) + ex);
            ex.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java org.apache.tomcat.startup.Tomcat {options}");
        System.out.println("  Options are:");
        System.out.println("    -config file (or -f file)  Use this file instead of server.xml");
        System.out.println("    -help (or help)            Show this usage report");
        System.out.println("    -home dir (or -h dir)      Use this directory as tomcat.home");
        System.out.println("    -stop                      Shut down currently running Tomcat");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("help")) {
                Tomcat.printUsage();
                return false;
            }
            if (arg.equals("-stop")) {
                this.doStop = true;
            } else if (arg.equals("-f") || arg.equals("-config")) {
                if (++i >= args.length) {
                    Tomcat.printUsage();
                    return false;
                }
                this.configFile = args[i];
            } else {
                if (!arg.equals("-h") && !arg.equals("-home")) {
                    Tomcat.printUsage();
                    return false;
                }
                if (++i >= args.length) {
                    Tomcat.printUsage();
                    return false;
                }
                ((Hashtable)System.getProperties()).put("tomcat.home", args[i]);
            }
            ++i;
        }
        return true;
    }

    void setConnectorHelper(XmlMapper xh) {
        xh.addRule("ContextManager/Connector", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/Connector", xh.setParent("setServer", "java.lang.Object"));
        xh.addRule("ContextManager/Connector", xh.addChild("addServerConnector", "org.apache.tomcat.core.ServerConnector"));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodSetter("setProperty", 2));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodParam(0, "name"));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodParam(1, "value"));
    }

    void setHelper(XmlMapper xh) {
        xh.addRule("ContextManager", xh.setProperties());
        xh.addRule("ContextManager/ContextInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/ContextInterceptor", xh.setProperties());
        xh.addRule("ContextManager/ContextInterceptor", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/ContextInterceptor", xh.addChild("addContextInterceptor", "org.apache.tomcat.core.ContextInterceptor"));
        xh.addRule("ContextManager/RequestInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/RequestInterceptor", xh.setProperties());
        xh.addRule("ContextManager/RequestInterceptor", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/RequestInterceptor", xh.addChild("addRequestInterceptor", "org.apache.tomcat.core.RequestInterceptor"));
        xh.addRule("ContextManager/Context", xh.objectCreate("org.apache.tomcat.core.Context"));
        xh.addRule("ContextManager/Context", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/Context", xh.setProperties());
        xh.addRule("ContextManager/Context", xh.addChild("addContext", null));
        xh.addRule("ContextManager/Host", new XmlAction(){

            public void cleanup(SaxContext ctx) {
                Stack st = ctx.getObjectStack();
                Object o = st.pop();
            }

            public void start(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                int top = ctx.getTagCount() - 1;
                AttributeList attributes = ctx.getAttributeList(top);
                ContextManager cm = (ContextManager)st.peek();
                HostConfig hc = new HostConfig(cm);
                hc.setName(attributes.getValue("name"));
                st.push(hc);
            }
        });
        xh.addRule("ContextManager/Host", xh.setProperties());
        xh.addRule("ContextManager/Host/Context", xh.objectCreate("org.apache.tomcat.core.Context"));
        xh.addRule("ContextManager/Host/Context", xh.setProperties());
        xh.addRule("ContextManager/Host/Context", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                Context tcCtx = (Context)st.pop();
                HostConfig hc = (HostConfig)st.peek();
                st.push(tcCtx);
                hc.addContext(tcCtx);
            }
        });
    }

    void setLogHelper(XmlMapper xh) {
        xh.addRule("Server/Logger", xh.objectCreate("org.apache.tomcat.logging.TomcatLogger"));
        xh.addRule("Server/Logger", xh.setProperties());
        xh.addRule("Server/Logger", xh.addChild("addLogger", "org.apache.tomcat.logging.Logger"));
    }

    void stopTomcat() throws TomcatException {
        XmlMapper xh = new XmlMapper();
        xh.setDebug(0);
        ContextManager cm = new ContextManager();
        this.setConnectorHelper(xh);
        File f = this.getConfigFile(cm);
        try {
            xh.readXml(f, (Object)cm);
        }
        catch (Exception ex) {
            System.out.println(sm.getString("tomcat.fatalconfigerror"));
            ex.printStackTrace();
            System.exit(1);
        }
        StopTomcat stopTc = new StopTomcat();
        stopTc.execute(cm);
    }
}

