/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ErrorNode
extends AbstractNode
implements OffsetProvider {
    private CompilationInfo info;
    private Diagnostic diag;

    public ErrorNode(CompilationInfo compilationInfo, Diagnostic diagnostic) {
        super(Children.LEAF);
        this.info = compilationInfo;
        this.diag = diagnostic;
        String string = diagnostic.getMessage(Locale.ENGLISH);
        this.setDisplayName(diagnostic.getCode() + " " + (Object)((Object)diagnostic.getKind()) + ": " + string);
        this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/element.png");
    }

    public static Node getTree(CompilationInfo compilationInfo) {
        ArrayList arrayList = new ArrayList();
        new FindChildrenErrorVisitor(compilationInfo).scan(arrayList);
        Children.Array array = new Children.Array();
        array.add(arrayList.toArray(new Node[0]));
        return new AbstractNode((Children)array);
    }

    @Override
    public int getStart() {
        return (int)this.diag.getStartPosition();
    }

    @Override
    public int getEnd() {
        return (int)this.diag.getEndPosition();
    }

    @Override
    public int getPreferredPosition() {
        return (int)this.diag.getPosition();
    }

    private static class FindChildrenErrorVisitor {
        private CompilationInfo info;

        public FindChildrenErrorVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        private void scan(List<Node> list) {
            for (Diagnostic diagnostic : this.info.getDiagnostics()) {
                list.add((Node)new ErrorNode(this.info, diagnostic));
            }
        }
    }
}

