/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.input;

import java.awt.Component;
import java.awt.event.KeyEvent;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.KeyDriver;
import org.netbeans.jemmy.drivers.input.EventDriver;
import org.netbeans.jemmy.operators.ComponentOperator;

public class KeyEventDriver
extends EventDriver
implements KeyDriver {
    public KeyEventDriver(String[] supported) {
        super(supported);
    }

    public KeyEventDriver() {
    }

    public void pressKey(ComponentOperator oper, int keyCode, int modifiers) {
        this.pressKey(this.findNativeParent(oper.getSource()), keyCode, modifiers);
    }

    public void releaseKey(ComponentOperator oper, int keyCode, int modifiers) {
        this.releaseKey(this.findNativeParent(oper.getSource()), keyCode, modifiers);
    }

    public void pushKey(ComponentOperator oper, int keyCode, int modifiers, Timeout pushTime) {
        Component nativeContainer = this.findNativeParent(oper.getSource());
        this.pressKey(nativeContainer, keyCode, modifiers);
        pushTime.sleep();
        this.releaseKey(nativeContainer, keyCode, modifiers);
    }

    public void typeKey(ComponentOperator oper, int keyCode, char keyChar, int modifiers, Timeout pushTime) {
        Component nativeContainer = this.findNativeParent(oper.getSource());
        this.pressKey(nativeContainer, keyCode, modifiers);
        pushTime.sleep();
        this.dispatchEvent(nativeContainer, new KeyEvent(nativeContainer, 400, System.currentTimeMillis(), modifiers, 0, keyChar));
        this.releaseKey(nativeContainer, keyCode, modifiers);
    }

    private void pressKey(Component nativeContainer, int keyCode, int modifiers) {
        this.dispatchEvent(nativeContainer, new KeyEvent(nativeContainer, 401, System.currentTimeMillis(), modifiers, keyCode));
    }

    private void releaseKey(Component nativeContainer, int keyCode, int modifiers) {
        this.dispatchEvent(nativeContainer, new KeyEvent(nativeContainer, 402, System.currentTimeMillis(), modifiers, keyCode));
    }

    private Component findNativeParent(Component source) {
        for (Component nativeOne = source; nativeOne != null; nativeOne = nativeOne.getParent()) {
            if (nativeOne.isLightweight()) continue;
            return nativeOne;
        }
        return source;
    }
}

