/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Graphics;
import javax.swing.JViewport;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;

public class CustomTimeLineViewport
extends JViewport {
    private ThreadsPanel viewManager;
    private int paintWidth;
    private int paintX;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private TimeLine timeLine;

    public CustomTimeLineViewport(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
        this.syncViewVariables();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setClip(this.paintX, this.getEmptySpaceY(), this.paintWidth, this.getHeight() - this.getEmptySpaceY());
        this.paintTimeMarks(g);
    }

    private int getEmptySpaceY() {
        if (this.getView() == null) {
            return 0;
        }
        return this.getView().getHeight();
    }

    private void paintTimeMarks(Graphics g) {
        this.syncViewVariables();
        if (this.viewEnd - this.viewStart > 0L) {
            long time;
            int firstValue = (int)(this.viewStart - this.dataStart);
            int lastValue = (int)(this.viewEnd - this.dataStart);
            float factor = (float)this.paintWidth / (float)(this.viewEnd - this.viewStart);
            int optimalUnits = TimeLineUtils.getOptimalUnits(factor);
            int firstMark = Math.max((int)(Math.ceil((double)firstValue / (double)optimalUnits) * (double)optimalUnits), 0);
            for (int currentMark = firstMark - optimalUnits; currentMark <= lastValue + optimalUnits; currentMark += optimalUnits) {
                if (currentMark < 0) continue;
                float currentMarkRel = currentMark - firstValue;
                int markPosition = (int)(currentMarkRel * factor);
                this.paintTimeTicks(g, (int)(currentMarkRel * factor), (int)((currentMarkRel + (float)optimalUnits) * factor), TimeLineUtils.getTicksCount(optimalUnits));
                g.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                g.drawLine(this.paintX + markPosition, this.getEmptySpaceY(), this.paintX + markPosition, this.getHeight() - 1);
            }
            if (this.timeLine != null && this.viewStart < (time = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && time < this.viewEnd) {
                int x = (int)((long)this.paintWidth * (time - this.viewStart) / (this.viewEnd - this.viewStart));
                g.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
                if (this.getHeight() - 1 - this.getEmptySpaceY() < 5) {
                    g.drawLine(this.paintX + x, this.getEmptySpaceY(), this.paintX + x, this.getHeight() - 1);
                } else {
                    g.drawLine(this.paintX + x, this.getEmptySpaceY(), this.paintX + x, this.getHeight() - 1 - 5);
                    g.drawLine(this.paintX + x - 3, this.getHeight() - 1, this.paintX + x - 3, this.getHeight() - 1 - 2);
                    g.drawLine(this.paintX + x - 3, this.getHeight() - 1 - 2, this.paintX + x, this.getHeight() - 1 - 5);
                    g.drawLine(this.paintX + x, this.getHeight() - 1 - 5, this.paintX + x + 3, this.getHeight() - 1 - 2);
                    g.drawLine(this.paintX + x + 3, this.getHeight() - 1 - 2, this.paintX + x + 3, this.getHeight() - 1);
                    g.drawLine(this.paintX + x + 3, this.getHeight() - 1, this.paintX + x - 3, this.getHeight() - 1);
                }
            }
        }
    }

    private void paintTimeTicks(Graphics g, int startPos, int endPos, int count) {
        float factor = (float)(endPos - startPos) / (float)count;
        g.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < count; ++i) {
            int x = startPos + (int)((float)i * factor);
            g.drawLine(this.paintX + x, this.getEmptySpaceY(), this.paintX + x, this.getHeight() - 1);
        }
    }

    private void syncViewVariables() {
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.timeLine = this.viewManager.getTimeLine();
        this.paintWidth = this.viewManager.getDisplayColumnWidth();
        int rest = this.viewManager.getDisplayColumnRest();
        this.paintX = this.getWidth() - this.paintWidth - rest;
    }
}

