/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.visualizers.support.TimeIntervalPanel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class VisualizerTopComponentTopComponent
extends TopComponent
implements VisualizerContainer,
DLightSessionListener {
    private static VisualizerTopComponentTopComponent instance;
    private static final String PREFERRED_ID = "VisualizerTopComponentTopComponent";
    private JPanel performanceMonitorViewsArea = new JPanel();
    private TimeIntervalPanel toolbarArea = new TimeIntervalPanel(null);
    private JComponent viewComponent;
    private String currentToolName;
    private DLightSession session;

    private VisualizerTopComponentTopComponent() {
        this.initComponents();
        this.initPerformanceMonitorViewComponents();
        this.setName(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"CTL_VisualizerTopComponentTopComponent"));
        this.setToolTipText(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"HINT_VisualizerTopComponentTopComponent"));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized VisualizerTopComponentTopComponent getDefault() {
        if (instance == null) {
            instance = new VisualizerTopComponentTopComponent();
        }
        return instance;
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.viewComponent != null) {
            super.requestFocusInWindow(false);
            this.viewComponent.requestFocus();
        }
    }

    public static synchronized VisualizerTopComponentTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(VisualizerTopComponentTopComponent.class.getName()).warning("Cannot find VisualizerTopComponentTopComponent component. It will not be located properly in the window system.");
            return VisualizerTopComponentTopComponent.getDefault();
        }
        if (win instanceof VisualizerTopComponentTopComponent) {
            return (VisualizerTopComponentTopComponent)win;
        }
        Logger.getLogger(VisualizerTopComponentTopComponent.class.getName()).warning("There seem to be multiple components with the 'VisualizerTopComponentTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return VisualizerTopComponentTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        DLightManager.getDefault().removeDLightSessionListener((DLightSessionListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void setContent(String toolName, JComponent viewComponent) {
        if (this.currentToolName != null && this.currentToolName.equals(toolName) && this.viewComponent == viewComponent) {
            return;
        }
        this.currentToolName = toolName;
        this.performanceMonitorViewsArea.removeAll();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.viewComponent = viewComponent;
        this.performanceMonitorViewsArea.add(viewComponent);
        this.toolbarArea.update((DataFilterManager)DLightManager.getDefault().getActiveSession());
        this.setName(toolName);
        this.setToolTipText(toolName);
        this.validate();
        this.repaint();
    }

    public void addVisualizer(String toolID, String toolName, Visualizer<?> view) {
        this.setContent(toolName, view.getComponent());
        view.refresh();
    }

    public void showup() {
        this.open();
        this.requestActive();
    }

    public void removeVisualizer(final Visualizer<?> v) {
        if (EventQueue.isDispatchThread()) {
            this.closePerformanceMonitor(v);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VisualizerTopComponentTopComponent.this.closePerformanceMonitor(v);
                }
            });
        }
    }

    @Deprecated
    public void requestFocus() {
        if (this.viewComponent != null) {
            this.viewComponent.requestFocus();
        } else {
            super.requestFocus(true);
        }
    }

    public void addContent(String toolName, JComponent viewComponent) {
        if (this.currentToolName == null || !this.currentToolName.equals(toolName) || this.viewComponent != viewComponent) {
            this.currentToolName = toolName;
            this.performanceMonitorViewsArea.removeAll();
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
        }
        this.viewComponent = viewComponent;
        this.performanceMonitorViewsArea.add(viewComponent);
        this.toolbarArea.update((DataFilterManager)DLightManager.getDefault().getActiveSession());
        this.setName(toolName);
        this.setToolTipText(toolName);
        this.validate();
        this.repaint();
    }

    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        this.session = newSession;
        this.toolbarArea.update((DataFilterManager)this.session);
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
    }

    private void initPerformanceMonitorViewComponents() {
        this.setLayout(new BorderLayout());
        this.performanceMonitorViewsArea.setLayout(new BorderLayout());
        this.add(this.toolbarArea, "North");
        this.add(this.performanceMonitorViewsArea, "Center");
    }

    public void closePerformanceMonitor(Visualizer<?> view) {
        if (this.viewComponent != view.getComponent()) {
            return;
        }
        this.toolbarArea.update((DataFilterManager)null);
        this.performanceMonitorViewsArea.remove(view.getComponent());
        this.setName(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"RunMonitorDetailes"));
        this.repaint();
    }

    private static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ResolvableHelper() {
        }

        public Object readResolve() {
            return VisualizerTopComponentTopComponent.getDefault();
        }
    }
}

