/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class TemplateChooserPanelGUI
extends JPanel
implements PropertyChangeListener,
AsyncGUIJob {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject templatesFolder;
    private TemplatesPanelGUI.Builder builder = new FileChooserBuilder();
    private Project project;
    private String category;
    private String template;
    private boolean isWarmUp = true;
    private ListCellRenderer projectCellRenderer;
    private boolean firstTime = true;
    private JLabel jLabel1;
    private JComboBox projectsComboBox;
    private JPanel templatesPanel;

    public TemplateChooserPanelGUI() {
        this.initComponents();
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_Name"));
        this.projectCellRenderer = new ProjectCellRenderer();
        this.projectsComboBox.setRenderer(this.projectCellRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues(Project p, String category, String template) {
        boolean wf;
        assert (p != null) : "Project can not be null";
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            this.project = p;
            this.category = category;
            this.template = template;
            wf = this.isWarmUp;
        }
        if (!wf) {
            this.selectProject(this.project);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(this.category);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedTemplateByName(this.template);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.project = null;
    }

    private void initValues(Project p) {
        Project[] openProjects = OpenProjectList.getDefault().getOpenProjects();
        Arrays.sort(openProjects, OpenProjectList.projectByDisplayName());
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(openProjects);
        this.projectsComboBox.setModel(projectsModel);
        this.selectProject(p);
    }

    private void selectProject(Project p) {
        if (p != null) {
            DefaultComboBoxModel projectsModel = (DefaultComboBoxModel)this.projectsComboBox.getModel();
            if (projectsModel.getIndexOf(p) == -1) {
                projectsModel.insertElementAt(p, 0);
            }
            this.projectsComboBox.setSelectedItem(p);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject() {
        boolean wf;
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            wf = this.isWarmUp;
        }
        if (wf) {
            return this.project;
        }
        return (Project)this.projectsComboBox.getSelectedItem();
    }

    public FileObject getTemplate() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireChange();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public String getCategoryName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedCategoryName();
    }

    public String getTemplateName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplateName();
    }

    public void setCategory(String category) {
        ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(category);
    }

    @Override
    public void addNotify() {
        if (this.firstTime) {
            Utilities.attachInitJob((Component)this, (AsyncGUIJob)this);
            this.firstTime = false;
        }
        super.addNotify();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.templatesPanel = new TemplatesPanelGUI(this.builder);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 13, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"ACSN_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"ACSD_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.templatesPanel, gridBagConstraints);
    }

    private static boolean isTemplate(DataObject dobj) {
        if (dobj.isTemplate()) {
            return true;
        }
        if (dobj instanceof DataShadow) {
            return ((DataShadow)dobj).getOriginal().isTemplate();
        }
        return false;
    }

    private boolean hasChildren(Project p, DataObject folder) {
        if (!(folder instanceof DataFolder)) {
            return false;
        }
        DataFolder f = (DataFolder)folder;
        if (!OpenProjectList.isRecommended(p, f.getPrimaryFile())) {
            return false;
        }
        DataObject[] ch = f.getChildren();
        boolean ok = false;
        for (int i = 0; i < ch.length; ++i) {
            if (TemplateChooserPanelGUI.isTemplate(ch[i]) && OpenProjectList.isRecommended(p, ch[i].getPrimaryFile())) {
                if (ch[i] instanceof DataShadow) continue;
                ok = true;
                break;
            }
            if (!(ch[i] instanceof DataFolder) || !this.hasChildren(p, ch[i])) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public void construct() {
        this.templatesFolder = FileUtil.getConfigFile((String)"Templates");
        ((TemplatesPanelGUI)this.templatesPanel).warmUp(this.templatesFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        TemplateChooserPanelGUI templateChooserPanelGUI;
        Cursor cursor = null;
        try {
            String t;
            String c;
            Project p;
            TemplateChooserPanelGUI templateChooserPanelGUI2 = this;
            synchronized (templateChooserPanelGUI2) {
                p = this.project;
                c = this.category;
                t = this.template;
            }
            cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.initValues(p);
            ((TemplatesPanelGUI)this.templatesPanel).doFinished(this.templatesFolder, c, t);
            templateChooserPanelGUI = this;
        }
        catch (Throwable throwable) {
            TemplateChooserPanelGUI templateChooserPanelGUI3 = this;
            synchronized (templateChooserPanelGUI3) {
                this.isWarmUp = false;
            }
            if (cursor != null) {
                this.setCursor(cursor);
            }
            throw throwable;
        }
        synchronized (templateChooserPanelGUI) {
            this.isWarmUp = false;
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof Project) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.setText(pi.getDisplayName());
                this.setIcon(pi.getIcon());
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private final class FileChooserBuilder
    implements TemplatesPanelGUI.Builder {
        private FileChooserBuilder() {
        }

        @Override
        public Children createCategoriesChildren(DataFolder folder) {
            return new TemplateChildren(folder);
        }

        @Override
        public Children createTemplatesChildren(DataFolder folder) {
            return new FileChildren(folder);
        }

        @Override
        public void fireChange() {
            TemplateChooserPanelGUI.this.fireChange();
        }

        @Override
        public String getCategoriesName() {
            return NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"CTL_Categories");
        }

        @Override
        public String getTemplatesName() {
            return NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"CTL_Files");
        }
    }

    private final class FileChildren
    extends Children.Keys<DataObject> {
        private DataFolder root;

        public FileChildren(DataFolder folder) {
            this.root = folder;
            assert (this.root != null) : "Root can not be null";
        }

        protected void addNotify() {
            this.setKeys(this.root.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new DataObject[0]);
        }

        protected Node[] createNodes(DataObject dobj) {
            if (TemplateChooserPanelGUI.isTemplate(dobj) && OpenProjectList.isRecommended(TemplateChooserPanelGUI.this.getProject(), dobj.getPrimaryFile())) {
                if (dobj instanceof DataShadow) {
                    dobj = ((DataShadow)dobj).getOriginal();
                }
                return new Node[]{new FilterNode(dobj.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[0];
        }
    }

    private final class TemplateChildren
    extends Children.Keys<DataFolder>
    implements ActionListener {
        private final DataFolder folder;

        TemplateChildren(DataFolder folder) {
            this.folder = folder;
        }

        protected void addNotify() {
            super.addNotify();
            TemplateChooserPanelGUI.this.projectsComboBox.addActionListener(this);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            TemplateChooserPanelGUI.this.projectsComboBox.removeActionListener(this);
            super.removeNotify();
        }

        private void updateKeys() {
            ArrayList<DataFolder> l = new ArrayList<DataFolder>();
            for (DataObject d : this.folder.getChildren()) {
                FileObject prim = d.getPrimaryFile();
                if (!this.acceptTemplate(d, prim) || !TemplateChooserPanelGUI.this.hasChildren((Project)TemplateChooserPanelGUI.this.projectsComboBox.getSelectedItem(), d)) continue;
                l.add((DataFolder)d);
            }
            this.setKeys(l);
        }

        protected Node[] createNodes(DataFolder d) {
            boolean haveChildren = false;
            for (DataObject child : d.getChildren()) {
                if (!(child instanceof DataFolder) || TemplateChooserPanelGUI.isTemplate(child)) continue;
                haveChildren = true;
                break;
            }
            if (!haveChildren) {
                return new Node[]{new FilterNode(d.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[]{new FilterNode(d.getNodeDelegate(), (Children)new TemplateChildren(d))};
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String cat = TemplateChooserPanelGUI.this.getCategoryName();
            String template = ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).getSelectedTemplateName();
            this.setKeys(Collections.emptySet());
            this.updateKeys();
            TemplateChooserPanelGUI.this.setCategory(cat);
            ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).setSelectedTemplateByName(template);
        }

        private boolean acceptTemplate(DataObject d, FileObject primaryFile) {
            if (d instanceof DataFolder && !TemplateChooserPanelGUI.isTemplate((DataObject)((DataFolder)d))) {
                Object o = primaryFile.getAttribute("simple");
                return o == null || Boolean.TRUE.equals(o);
            }
            return false;
        }
    }
}

