/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.processor;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor6;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"org.netbeans.modules.java.hints.jackpot.code.spi.*"})
public class JavaHintsAnnotationProcessor
extends LayerGeneratingProcessor {
    private static final Logger LOG = Logger.getLogger(JavaHintsAnnotationProcessor.class.getName());
    private final Set<String> hintTypes = new HashSet<String>();
    private static final String[] TRIGGERS = new String[]{"org.netbeans.modules.java.hints.jackpot.code.spi.TriggerTreeKind", "org.netbeans.modules.java.hints.jackpot.code.spi.TriggerPattern"};
    static final String ERR_RETURN_TYPE = "The return type must be either org.netbeans.spi.editor.hints.ErrorDescription or java.util.List<org.netbeans.spi.editor.hints.ErrorDescription>";
    static final String ERR_PARAMETERS = "The method must have exactly one parameter of type org.netbeans.modules.jackpot30.spi.HintContext";
    static final String ERR_MUST_BE_STATIC = "The method must be static";
    static final String WARN_BUNDLE_KEY_NOT_FOUND = "Bundle key %s not found";

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (!roundEnv.processingOver()) {
            this.generateTypeList("org.netbeans.modules.java.hints.jackpot.code.spi.Hint", roundEnv, this.hintTypes);
        } else {
            this.generateTypeFile(this.hintTypes);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void generateTypeList(String annotationName, RoundEnvironment roundEnv, Set<String> hintTypes) {
        TypeElement hint = this.processingEnv.getElementUtils().getTypeElement(annotationName);
        if (hint == null) {
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(hint)) {
            void var6_6;
            if (!this.verifyHintAnnotationAcceptable(element)) continue;
            if (!element.getKind().isClass() && !element.getKind().isInterface()) {
                if (element.getKind() != ElementKind.METHOD) continue;
                Element element2 = element.getEnclosingElement();
            } else if (!element.getKind().isClass()) continue;
            if (!var6_6.getKind().isClass()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error - cannot find class containing the hint", (Element)var6_6);
                continue;
            }
            TypeElement current = (TypeElement)var6_6;
            hintTypes.add(current.getQualifiedName().toString());
        }
        for (String ann : TRIGGERS) {
            TypeElement annRes = this.processingEnv.getElementUtils().getTypeElement(ann);
            if (annRes == null) continue;
            for (ExecutableElement method : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(hint))) {
                this.verifyHintMethod(method);
            }
        }
    }

    private void generateTypeFile(Set<String> types) {
        for (String fqn : types) {
            TypeElement clazz = this.processingEnv.getElementUtils().getTypeElement(fqn);
            LayerBuilder builder = this.layer(new Element[]{clazz});
            LayerBuilder.File clazzFolder = builder.folder("org-netbeans-modules-java-hints/code-hints/" + this.getFQN(clazz).replace('.', '-') + ".class");
            for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
                this.dumpAnnotation(builder, clazzFolder, annotationMirror);
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                if (executableElement.getAnnotationMirrors().isEmpty()) continue;
                LayerBuilder.File methodFolder = builder.folder(clazzFolder.getPath() + "/" + executableElement.getSimpleName() + ".method");
                for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                    this.dumpAnnotation(builder, methodFolder, annotationMirror);
                }
                methodFolder.write();
            }
            clazzFolder.write();
        }
    }

    private void dumpAnnotation(LayerBuilder builder, LayerBuilder.File folder, AnnotationMirror annotation) {
        String fqn = this.getFQN((TypeElement)annotation.getAnnotationType().asElement()).replace('.', '-');
        LayerBuilder.File annotationFolder = builder.folder(folder.getPath() + "/" + fqn + ".annotation");
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotation.getElementValues().entrySet()) {
            String attrName = e.getKey().getSimpleName().toString();
            e.getValue().accept(new DumpAnnotationValue(builder, annotationFolder, attrName), null);
        }
        annotationFolder.write();
    }

    private String getFQN(TypeElement clazz) {
        return this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
    }

    private boolean verifyHintAnnotationAcceptable(Element hint) {
        String id = "";
        for (AnnotationMirror annotationMirror : hint.getAnnotationMirrors()) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals("org.netbeans.modules.java.hints.jackpot.code.spi.Hint")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals("id")) continue;
                id = (String)e.getValue().getValue();
            }
        }
        if (id == null || id.length() == 0) {
            switch (hint.getKind()) {
                case CLASS: {
                    id = ((TypeElement)hint).getQualifiedName().toString();
                    break;
                }
                case METHOD: {
                    TypeElement hintClass = (TypeElement)hint.getEnclosingElement();
                    id = hintClass.getQualifiedName() + "." + hint.getSimpleName();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        Element hintPackage = hint;
        while (hintPackage.getKind() != ElementKind.PACKAGE) {
            hintPackage = hintPackage.getEnclosingElement();
        }
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, ((PackageElement)hintPackage).getQualifiedName(), "Bundle.properties");
            PropertyResourceBundle rb = new PropertyResourceBundle(fileObject.openInputStream());
            this.checkBundle(rb, "DN_" + id, hint);
            this.checkBundle(rb, "DESC_" + id, hint);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, null, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.FINE, null, illegalArgumentException);
        }
        return true;
    }

    private void checkBundle(ResourceBundle bundle, String key, Element ref) {
        try {
            bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(WARN_BUNDLE_KEY_NOT_FOUND, key), ref);
        }
    }

    private boolean verifyHintMethod(ExecutableElement method) {
        StringBuilder error = new StringBuilder();
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement errDesc = elements.getTypeElement("org.netbeans.spi.editor.hints.ErrorDescription");
        TypeElement juList = elements.getTypeElement("java.util.List");
        TypeElement hintCtx = elements.getTypeElement("org.netbeans.modules.java.hints.jackpot.spi.HintContext");
        if (errDesc == null || juList == null || hintCtx == null) {
            return true;
        }
        Types types = this.processingEnv.getTypeUtils();
        TypeMirror errDescType = errDesc.asType();
        DeclaredType juListErrDesc = types.getDeclaredType(juList, errDescType);
        TypeMirror ret = method.getReturnType();
        if (!types.isSameType(ret, errDescType) && !types.isSameType(ret, juListErrDesc)) {
            error.append(ERR_RETURN_TYPE);
            error.append("\n");
        }
        if (method.getParameters().size() != 1 || !types.isSameType(method.getParameters().get(0).asType(), hintCtx.asType())) {
            error.append(ERR_PARAMETERS);
            error.append("\n");
        }
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            error.append(ERR_MUST_BE_STATIC);
            error.append("\n");
        }
        if (error.length() == 0) {
            return true;
        }
        if (error.charAt(error.length() - 1) == '\n') {
            error.delete(error.length() - 1, error.length());
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error.toString(), method);
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DumpAnnotationValue
    extends AbstractAnnotationValueVisitor6<Void, Void> {
        private final LayerBuilder builder;
        private final LayerBuilder.File annotationFolder;
        private final String attrName;

        public DumpAnnotationValue(LayerBuilder builder, LayerBuilder.File annotationFolder, String attrName) {
            this.builder = builder;
            this.annotationFolder = annotationFolder;
            this.attrName = attrName;
        }

        @Override
        public Void visitBoolean(boolean b, Void p) {
            this.annotationFolder.boolvalue(this.attrName, b);
            return null;
        }

        @Override
        public Void visitByte(byte b, Void p) {
            this.annotationFolder.bytevalue(this.attrName, b);
            return null;
        }

        @Override
        public Void visitChar(char c, Void p) {
            this.annotationFolder.charvalue(this.attrName, c);
            return null;
        }

        @Override
        public Void visitDouble(double d, Void p) {
            this.annotationFolder.doublevalue(this.attrName, d);
            return null;
        }

        @Override
        public Void visitFloat(float f, Void p) {
            this.annotationFolder.floatvalue(this.attrName, f);
            return null;
        }

        @Override
        public Void visitInt(int i, Void p) {
            this.annotationFolder.intvalue(this.attrName, i);
            return null;
        }

        @Override
        public Void visitLong(long i, Void p) {
            this.annotationFolder.longvalue(this.attrName, i);
            return null;
        }

        @Override
        public Void visitShort(short s, Void p) {
            this.annotationFolder.shortvalue(this.attrName, s);
            return null;
        }

        @Override
        public Void visitString(String s, Void p) {
            this.annotationFolder.stringvalue(this.attrName, s);
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Void p) {
            this.annotationFolder.stringvalue(this.attrName, JavaHintsAnnotationProcessor.this.getFQN((TypeElement)((DeclaredType)t).asElement()));
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, Void p) {
            TypeElement owner = (TypeElement)c.getEnclosingElement();
            this.annotationFolder.stringvalue(this.attrName, JavaHintsAnnotationProcessor.this.getFQN(owner) + "." + c.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Void p) {
            LayerBuilder.File f = this.builder.folder(this.annotationFolder.getPath() + "/" + this.attrName);
            JavaHintsAnnotationProcessor.this.dumpAnnotation(this.builder, f, a);
            f.write();
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
            LayerBuilder.File arr = this.builder.folder(this.annotationFolder.getPath() + "/" + this.attrName);
            int c = 0;
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(new DumpAnnotationValue(this.builder, arr, "item" + c), null);
                ++c;
            }
            arr.write();
            return null;
        }
    }
}

