/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.modules.csl.api.InstantRenameAction;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.SelectCodeElementAction;
import org.netbeans.modules.csl.api.ToggleBlockCommentAction;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.deprecated.HtmlSyntax;
import org.netbeans.modules.web.core.syntax.deprecated.Jsp11Syntax;
import org.netbeans.modules.web.core.syntax.spi.JspColoringData;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

public class JspKit
extends NbEditorKit
implements HelpCtx.Provider {
    private static final WeakHashMap<Document, String> SOURCE_LEVEL_MAP = new WeakHashMap();
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String TAG_MIME_TYPE = "text/x-tag";
    private static final long serialVersionUID = 8933974837050367142L;
    public static final boolean debug = false;
    private final String mimeType;
    private static final String NULL_SOURCE_LEVEL = "NullSourceLevel";

    private static JspKit createKitForJsp() {
        return new JspKit(JSP_MIME_TYPE);
    }

    private static JspKit createKitForTag() {
        return new JspKit(TAG_MIME_TYPE);
    }

    public JspKit(String string) {
        this.mimeType = string;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public Object clone() {
        return new JspKit(this.mimeType);
    }

    public Syntax createSyntax(Document document) {
        Syntax syntax = JspKit.getSyntaxForLanguage(document, JspUtils.getContentLanguage());
        Syntax syntax2 = JspKit.getSyntaxForLanguage(document, JspUtils.getScriptingLanguage());
        Jsp11Syntax jsp11Syntax = new Jsp11Syntax(syntax, syntax2);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        FileObject fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
        JspColoringData jspColoringData = JspUtils.getJSPColoringData(fileObject);
        ColoringListener coloringListener = new ColoringListener(document, jspColoringData, jsp11Syntax);
        if (jspColoringData != null) {
            jspColoringData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)coloringListener, (Object)jspColoringData));
        }
        return jsp11Syntax;
    }

    public Document createDefaultDocument() {
        final Document document = super.createDefaultDocument();
        document.putProperty("postInitRunnable", new Runnable(){

            @Override
            public void run() {
                JspKit.this.initLexerColoringListener(document);
            }
        });
        return document;
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JspInsertBreakAction(), new JspDefaultKeyTypedAction(), new JspDeleteCharAction("delete-previous", false), new JspDeleteCharAction("delete-next", true), new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new InstantRenameAction(), new ToggleBlockCommentAction(), new ExtKit.CommentAction(""), new ExtKit.UncommentAction("")};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Syntax getSyntaxForLanguage(Document document, String string) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        if (editorKit instanceof JavaKit) {
            WeakHashMap<Document, String> weakHashMap = SOURCE_LEVEL_MAP;
            synchronized (weakHashMap) {
                String string2 = SOURCE_LEVEL_MAP.get(document);
                if (string2 == null) {
                    JavaKit javaKit = (JavaKit)editorKit;
                    string2 = javaKit.getSourceLevel((BaseDocument)document);
                    if (string2 == null) {
                        string2 = NULL_SOURCE_LEVEL;
                    }
                    SOURCE_LEVEL_MAP.put(document, string2);
                }
                return new JavaSyntax(string2 == NULL_SOURCE_LEVEL ? null : string2, true);
            }
        }
        return new HtmlSyntax();
    }

    private void initLexerColoringListener(Document document) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        FileObject fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
        JspColoringData jspColoringData = JspUtils.getJSPColoringData(fileObject);
        if (jspColoringData == null) {
            return;
        }
        JspParseData jspParseData = new JspParseData(jspColoringData.getPrefixMapper(), jspColoringData.isELIgnored(), jspColoringData.isXMLSyntax(), jspColoringData.isInitialized());
        LexerColoringListener lexerColoringListener = new LexerColoringListener(document, jspColoringData, jspParseData);
        jspColoringData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)lexerColoringListener, (Object)jspColoringData));
        document.putProperty(LexerColoringListener.class, lexerColoringListener);
        InputAttributes inputAttributes = new InputAttributes();
        inputAttributes.setValue(JspTokenId.language(), JspParseData.class, (Object)jspParseData, false);
        document.putProperty(InputAttributes.class, inputAttributes);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JspKit.class);
    }

    private static boolean completionSettingEnabled() {
        return true;
    }

    public static class JspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        JTextComponent currentTarget;

        public JspDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.currentTarget = jTextComponent;
            if (jTextComponent != null) {
                Action action;
                JavaKit javaKit;
                TokenSequence tokenSequence;
                AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
                abstractDocument.readLock();
                try {
                    tokenSequence = JspSyntaxSupport.tokenSequence(TokenHierarchy.get((Document)jTextComponent.getDocument()), JavaTokenId.language(), jTextComponent.getCaret().getDot() - 1);
                }
                finally {
                    abstractDocument.readUnlock();
                }
                if (tokenSequence != null && (javaKit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = javaKit.getActionByName(this.nextChar ? "delete-next" : "delete-previous")) != null && action instanceof JavaKit.JavaDeleteCharAction) {
                    ((JavaKit.JavaDeleteCharAction)action).actionPerformed(actionEvent, jTextComponent);
                    return;
                }
            }
            super.actionPerformed(actionEvent, jTextComponent);
            this.currentTarget = null;
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            KeystrokeHandler keystrokeHandler;
            if (JspKit.completionSettingEnabled() && (keystrokeHandler = UiUtils.getBracketCompletion((Document)baseDocument, (int)n)) != null) {
                keystrokeHandler.charBackspaced((Document)baseDocument, n, this.currentTarget, c);
                return;
            }
            super.charBackspaced(baseDocument, n, caret, c);
        }
    }

    public static class JspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private JTextComponent currentTarget;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block4: {
                this.currentTarget = jTextComponent;
                try {
                    if (!this.triggerJavaDefaultKeyTypedAction(actionEvent, jTextComponent)) {
                        super.actionPerformed(actionEvent, jTextComponent);
                        break block4;
                    }
                    return;
                }
                finally {
                    this.currentTarget = null;
                }
            }
        }

        private boolean triggerJavaDefaultKeyTypedAction(final ActionEvent actionEvent, final JTextComponent jTextComponent) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final boolean[] blArray = new boolean[1];
            baseDocument.runAtomic(new Runnable(){

                @Override
                public void run() {
                    Action action;
                    JavaKit javaKit;
                    TokenSequence tokenSequence = JspSyntaxSupport.tokenSequence(TokenHierarchy.get((Document)jTextComponent.getDocument()), JavaTokenId.language(), jTextComponent.getCaret().getDot() - 1);
                    if (tokenSequence != null && (javaKit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = javaKit.getActionByName("default-typed")) != null && action instanceof JavaKit.JavaDefaultKeyTypedAction) {
                        ((JavaKit.JavaDefaultKeyTypedAction)action).actionPerformed(actionEvent, jTextComponent);
                        blArray[0] = true;
                    }
                }
            });
            return blArray[0];
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            KeystrokeHandler keystrokeHandler;
            if (JspKit.completionSettingEnabled() && (keystrokeHandler = UiUtils.getBracketCompletion((Document)baseDocument, (int)n)) != null) {
                boolean bl2 = keystrokeHandler.beforeCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                if (!bl2) {
                    super.insertString(baseDocument, n, caret, string, bl);
                    bl2 = keystrokeHandler.afterCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                }
                return;
            }
            super.insertString(baseDocument, n, caret, string, bl);
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (document instanceof BaseDocument) {
                KeystrokeHandler keystrokeHandler;
                BaseDocument baseDocument = (BaseDocument)document;
                if (JspKit.completionSettingEnabled() && (keystrokeHandler = UiUtils.getBracketCompletion((Document)baseDocument, (int)n)) != null) {
                    try {
                        int n2 = caret.getDot();
                        boolean bl2 = keystrokeHandler.beforeCharInserted((Document)baseDocument, n2, jTextComponent, c);
                        int n3 = Math.min(caret.getDot(), caret.getMark());
                        int n4 = Math.max(caret.getDot(), caret.getMark());
                        if (n3 != n4) {
                            baseDocument.remove(n3, n4 - n3);
                        }
                        if (!bl2 && string.length() > 0) {
                            baseDocument.insertString(n3, string, null);
                            bl2 = keystrokeHandler.afterCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    return;
                }
            }
            super.replaceSelection(jTextComponent, n, caret, string, bl);
        }
    }

    public static class JspInsertBreakAction
    extends BaseKit.InsertBreakAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Action action;
                JavaKit javaKit;
                TokenSequence tokenSequence;
                AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
                abstractDocument.readLock();
                try {
                    tokenSequence = JspSyntaxSupport.tokenSequence(TokenHierarchy.get((Document)jTextComponent.getDocument()), JavaTokenId.language(), jTextComponent.getCaret().getDot() - 1);
                }
                finally {
                    abstractDocument.readUnlock();
                }
                if (tokenSequence != null && (javaKit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = javaKit.getActionByName("insert-break")) != null && action instanceof JavaKit.JavaInsertBreakAction) {
                    ((JavaKit.JavaInsertBreakAction)action).actionPerformed(actionEvent, jTextComponent);
                    return;
                }
            }
            super.actionPerformed(actionEvent, jTextComponent);
        }

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            KeystrokeHandler keystrokeHandler;
            if (JspKit.completionSettingEnabled() && (keystrokeHandler = UiUtils.getBracketCompletion((Document)baseDocument, (int)caret.getDot())) != null) {
                try {
                    int n = keystrokeHandler.beforeBreak((Document)baseDocument, caret.getDot(), jTextComponent);
                    if (n >= 0) {
                        return new Integer(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (JspKit.completionSettingEnabled() && object != null && object instanceof Integer) {
                int n = (Integer)object;
                if (n != -1) {
                    caret.setDot(n);
                } else {
                    int n2 = caret.getDot();
                    caret.setDot(n2 + 1);
                }
            }
        }
    }

    private static class LexerColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private JspColoringData data;
        private JspParseData jspParseData;

        private LexerColoringListener(Document document, JspColoringData jspColoringData, JspParseData jspParseData) {
            this.doc = document;
            this.data = jspColoringData;
            this.jspParseData = jspParseData;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("parsingSuccessful".equals(propertyChangeEvent.getPropertyName())) {
                if (!this.jspParseData.initialized()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            NbEditorDocument nbEditorDocument = (NbEditorDocument)LexerColoringListener.this.doc;
                            nbEditorDocument.extWriteLock();
                            try {
                                LexerColoringListener.this.recolor();
                            }
                            finally {
                                nbEditorDocument.extWriteUnlock();
                            }
                        }
                    });
                }
            } else if ("coloringChange".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        NbEditorDocument nbEditorDocument = (NbEditorDocument)LexerColoringListener.this.doc;
                        nbEditorDocument.extWriteLock();
                        try {
                            LexerColoringListener.this.recolor();
                        }
                        finally {
                            nbEditorDocument.extWriteUnlock();
                        }
                    }
                });
            }
        }

        private void recolor() {
            this.jspParseData.updateParseData(this.data.getPrefixMapper(), this.data.isELIgnored(), this.data.isXMLSyntax());
            MutableTextInput mutableTextInput = (MutableTextInput)this.doc.getProperty(MutableTextInput.class);
            if (mutableTextInput != null) {
                mutableTextInput.tokenHierarchyControl().rebuild();
            }
        }
    }

    private static class ColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private Object parsedDataRef;
        private Jsp11Syntax syntax;

        public ColoringListener(Document document, JspColoringData jspColoringData, Jsp11Syntax jsp11Syntax) {
            this.doc = document;
            this.parsedDataRef = jspColoringData;
            this.syntax = jsp11Syntax;
            jsp11Syntax.listenerReference = this;
            jsp11Syntax.data = jspColoringData;
        }

        private void recolor() {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).invalidateSyntaxMarks();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.syntax == null) {
                return;
            }
            if (this.syntax.listenerReference != this) {
                this.syntax = null;
                return;
            }
            if ("coloringChange".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        NbEditorDocument nbEditorDocument = (NbEditorDocument)ColoringListener.this.doc;
                        nbEditorDocument.extWriteLock();
                        try {
                            ColoringListener.this.recolor();
                        }
                        finally {
                            nbEditorDocument.extWriteUnlock();
                        }
                    }
                });
            }
        }
    }
}

