/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.javascript.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static final Logger LOG = Logger.getLogger(RefactoringActionsProvider.class.getName());
    private static boolean isFindUsages;

    public void doRename(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        UserTask userTask = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            @Override
            protected RefactoringUI createRefactoringUI(JsElementCtx jsElementCtx, int n, int n2, JsParseResult jsParseResult) {
                return new RenameRefactoringUI(jsElementCtx);
            }
        } : new NodeToFileObjectTask(lookup.lookupAll(org.openide.nodes.Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<JsElementCtx> collection) {
                String string = RefactoringActionsProvider.getName(dictionary);
                if (string != null) {
                    if (this.pkg[0] != null) {
                        return new RenameRefactoringUI(this.pkg[0], string);
                    }
                    return new RenameRefactoringUI(fileObjectArray[0], string, collection == null || collection.isEmpty() ? null : collection.iterator().next());
                }
                if (this.pkg[0] != null) {
                    return new RenameRefactoringUI(this.pkg[0]);
                }
                return new RenameRefactoringUI(fileObjectArray[0], collection == null || collection.isEmpty() ? null : collection.iterator().next());
            }
        };
        userTask.run();
    }

    public boolean canRename(Lookup lookup) {
        Collection collection = lookup.lookupAll(org.openide.nodes.Node.class);
        if (collection.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.isOutsideJs(lookup, fileObject)) {
            return false;
        }
        return RetoucheUtils.isRefactorable(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOutsideJs(Lookup lookup, FileObject fileObject) {
        block7: {
            if (!JsUtils.isJsFile((FileObject)fileObject) && !JsUtils.isJsonFile((FileObject)fileObject)) {
                EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
                if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
                    JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
                    Document document = jEditorPane.getDocument();
                    if (!(document instanceof BaseDocument)) {
                        return true;
                    }
                    BaseDocument baseDocument = (BaseDocument)document;
                    baseDocument.readLock();
                    try {
                        int n = jEditorPane.getCaretPosition();
                        if (LexUtilities.getToken((Document)((BaseDocument)document), (int)n) == null) {
                            boolean bl = true;
                            return bl;
                        }
                        break block7;
                    }
                    finally {
                        baseDocument.readUnlock();
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean canCopy(Lookup lookup) {
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(org.openide.nodes.Node.class);
        if (collection.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isJsFile(fileObject) && this.isOutsideJs(lookup, fileObject)) {
            return false;
        }
        return dataObject != null && RetoucheUtils.isJsFile(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        UserTask userTask = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            @Override
            protected RefactoringUI createRefactoringUI(JsElementCtx jsElementCtx, int n, int n2, JsParseResult jsParseResult) {
                return new WhereUsedQueryUI(jsElementCtx);
            }
        } : new NodeToElementTask(lookup.lookupAll(org.openide.nodes.Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(JsElementCtx jsElementCtx, JsParseResult jsParseResult) {
                return new WhereUsedQueryUI(jsElementCtx);
            }
        };
        try {
            isFindUsages = true;
            userTask.run();
        }
        finally {
            isFindUsages = false;
        }
    }

    public boolean canDelete(Lookup lookup) {
        return false;
    }

    static String getName(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        return (String)dictionary.get("name");
    }

    public boolean canMove(Lookup lookup) {
        return false;
    }

    public void doMove(Lookup lookup) {
    }

    private static boolean isFromEditor(EditorCookie editorCookie) {
        TopComponent topComponent;
        return editorCookie != null && editorCookie.getOpenedPanes() != null && (topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static abstract class NodeToFileObjectTask
    extends UserTask
    implements Runnable {
        private final Collection<? extends org.openide.nodes.Node> nodes;
        protected final NonRecursiveFolder[] pkg;
        Collection<JsElementCtx> handles = new ArrayList<JsElementCtx>();

        public NodeToFileObjectTask(Collection<? extends org.openide.nodes.Node> collection) {
            assert (collection != null);
            this.nodes = collection;
            this.pkg = new NonRecursiveFolder[collection.size()];
        }

        public void run(ResultIterator resultIterator) throws Exception {
            block3: {
                block2: {
                    Object object2;
                    JsAnalyzer.AnalysisResult analysisResult;
                    List list;
                    if (!resultIterator.getSnapshot().getMimeType().equals("text/javascript")) break block2;
                    JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                    Node node = jsParseResult.getRootNode();
                    if (node == null || (list = (analysisResult = jsParseResult.getStructure()).getElements()).size() <= 0) break block3;
                    AstElement astElement = null;
                    for (Object object2 : list) {
                        if (!object2.getName().equals(resultIterator.getSnapshot().getSource().getFileObject().getName())) continue;
                        astElement = object2;
                    }
                    if (astElement == null) break block3;
                    Node node2 = astElement.getNode();
                    object2 = new JsElementCtx(node, node2, (Element)astElement, resultIterator.getSnapshot().getSource().getFileObject(), jsParseResult);
                    ((JsElementCtx)object2).setNames(astElement.getFqn(), astElement.getName());
                    this.handles.add((JsElementCtx)object2);
                    break block3;
                }
                for (Embedding embedding : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(embedding));
                }
            }
        }

        @Override
        public void run() {
            FileObject[] fileObjectArray = new FileObject[this.nodes.size()];
            int n = 0;
            for (org.openide.nodes.Node node : this.nodes) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null) continue;
                fileObjectArray[n] = dataObject.getPrimaryFile();
                Source source = Source.create((FileObject)fileObjectArray[n]);
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)this);
                }
                catch (ParseException parseException) {
                    LOG.log(Level.WARNING, null, parseException);
                }
                this.pkg[n++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fileObjectArray, this.handles));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<JsElementCtx> var2);
    }

    public static abstract class NodeToElementTask
    extends UserTask
    implements Runnable {
        private final org.openide.nodes.Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends org.openide.nodes.Node> collection) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
        }

        public void run(ResultIterator resultIterator) throws ParseException {
            if (resultIterator.getSnapshot().getMimeType().equals("text/javascript")) {
                JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                Node node = jsParseResult.getRootNode();
                if (node != null) {
                    AstElement astElement = AstElement.getElement((JsParseResult)jsParseResult, (Node)node);
                    JsElementCtx jsElementCtx = new JsElementCtx(node, node, (Element)astElement, resultIterator.getSnapshot().getSource().getFileObject(), jsParseResult);
                    this.ui = this.createRefactoringUI(jsElementCtx, jsParseResult);
                }
            } else {
                for (Embedding embedding : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(embedding));
                }
            }
        }

        @Override
        public final void run() {
            Object object;
            try {
                object = (DataObject)this.node.getCookie(DataObject.class);
                Source source = Source.create((FileObject)object.getPrimaryFile());
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
                return;
            }
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui);
            } else {
                object = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    object = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)object));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(JsElementCtx var1, JsParseResult var2);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final JTextComponent textC;
        private final int caret;
        private final int start;
        private final int end;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void run(ResultIterator resultIterator) throws ParseException {
            if (resultIterator.getSnapshot().getMimeType().equals("text/javascript")) {
                JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                Node node = jsParseResult.getRootNode();
                if (node != null) {
                    JsElementCtx jsElementCtx = new JsElementCtx(jsParseResult, this.caret);
                    if (jsElementCtx.getSimpleName() != null) {
                        this.ui = this.createRefactoringUI(jsElementCtx, this.start, this.end, jsParseResult);
                    }
                } else {
                    System.out.println("FAILURE - can't refactor uncompileable sources");
                }
            } else {
                for (Embedding embedding : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(embedding));
                }
            }
        }

        @Override
        public final void run() {
            Source source;
            try {
                source = Source.create((Document)this.textC.getDocument());
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
                return;
            }
            source = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)source);
            } else {
                String string = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    string = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)string));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(JsElementCtx var1, int var2, int var3, JsParseResult var4);
    }
}

