/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.pojson.JsonUtils;
import org.codeviation.pojson.StoreInfo;

class PojsonFormater {
    private Factory<StoreInfo, Class> sif;
    private String indent;
    private Writer w;

    public PojsonFormater(Factory<StoreInfo, Class> sif, String indent, Writer w) {
        this.sif = sif;
        this.indent = indent;
        this.w = w;
    }

    void write(Object object, int indentLevel) throws IOException {
        PojsonFormater.indent(this.w, this.indent, indentLevel);
        this.writeAny(object, indentLevel);
    }

    private void writeAny(Object object, int indentLevel) throws IOException {
        if (object == null) {
            this.w.write("null");
            return;
        }
        StoreInfo si = this.sif.create(object.getClass());
        switch (si.getKind()) {
            case ARRAY: {
                this.writeArray(si, JsonUtils.getIterator(object), indentLevel);
                break;
            }
            case OBJECT: {
                this.writeObject(si, object, indentLevel);
                break;
            }
            case VALUE: {
                this.writeValue(object);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown store kind");
            }
        }
    }

    private void writeObject(StoreInfo si, Object object, int indentLevel) throws IOException {
        if (object == null) {
            this.w.write("null");
            return;
        }
        this.w.write(123);
        if (object instanceof Map) {
            this.writeMap(si, (Map)object, indentLevel);
        } else {
            this.writePojo(si, object, indentLevel);
        }
        PojsonFormater.indent(this.w, this.indent, indentLevel);
        this.w.write(125);
    }

    private void writeMap(StoreInfo si, Map<?, ?> map, int indentLevel) throws IOException {
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!first) {
                this.w.write(44);
                if (this.indent != null) {
                    this.w.write(10);
                }
            } else {
                if (this.indent != null) {
                    this.w.write(10);
                }
                first = false;
            }
            PojsonFormater.key(this.w, entry.getKey().toString(), this.indent, indentLevel + 1);
            this.writeAny(value, indentLevel + 1);
        }
        if (!first && this.indent != null) {
            this.w.write(10);
        }
    }

    private void writePojo(StoreInfo si, Object object, int indentLevel) throws IOException {
        try {
            boolean first = true;
            for (Field f : si.getFields()) {
                f.setAccessible(true);
                Object value = f.get(object);
                if (value == null && si.isSkipNullValues(f)) continue;
                if (!first) {
                    this.w.write(44);
                    if (this.indent != null) {
                        this.w.write(10);
                    }
                } else {
                    if (this.indent != null) {
                        this.w.write(10);
                    }
                    first = false;
                }
                PojsonFormater.key(this.w, si.getPojsonFieldName(f), this.indent, indentLevel + 1);
                this.writeAny(value, indentLevel + 1);
            }
            if (!first && this.indent != null) {
                this.w.write(10);
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void writeValue(Object value) throws IOException {
        this.w.write(JsonUtils.toJsonString(value));
    }

    private <T> void writeArray(StoreInfo si, Iterator it, int indentLevel) throws IOException {
        if (it == null) {
            this.w.write("null");
            return;
        }
        this.w.write(91);
        boolean wasEmpty = true;
        while (it.hasNext()) {
            if (this.indent != null) {
                this.w.write(10);
            }
            wasEmpty = false;
            PojsonFormater.indent(this.w, this.indent, indentLevel + 1);
            this.writeAny(it.next(), indentLevel + 1);
            if (!it.hasNext()) continue;
            this.w.write(44);
        }
        if (!wasEmpty && this.indent != null) {
            this.w.write(10);
            PojsonFormater.indent(this.w, this.indent, indentLevel);
        }
        this.w.write(93);
    }

    private static void key(Writer w, String name, String indent, int indentLevel) throws IOException {
        PojsonFormater.indent(w, indent, indentLevel);
        w.write(JsonUtils.quote(name));
        w.write(58);
        if (indent != null) {
            w.write(32);
        }
    }

    private static void indent(Writer w, String indent, int indentLevel) throws IOException {
        if (indent == null || indentLevel == 0) {
            return;
        }
        for (int i = 0; i < indentLevel; ++i) {
            w.write(indent);
        }
    }
}

