/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.completion.DynamicElementHandler;
import org.netbeans.modules.groovy.editor.completion.GroovyElementHandler;
import org.netbeans.modules.groovy.editor.completion.JavaElementHandler;
import org.netbeans.modules.groovy.editor.completion.MetaElementHandler;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;

public final class CompleteElementHandler {
    private static final Logger LOG = Logger.getLogger(CompleteElementHandler.class.getName());
    private final ParserResult info;
    private final GroovyIndex index;

    private CompleteElementHandler(ParserResult parserResult) {
        this.info = parserResult;
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        this.index = fileObject != null ? GroovyIndex.get(QuerySupport.findRoots((FileObject)fileObject, Collections.singleton("classpath/source"), null, null)) : null;
    }

    public static CompleteElementHandler forCompilationInfo(ParserResult parserResult) {
        return new CompleteElementHandler(parserResult);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(ClassNode classNode, ClassNode classNode2, String string, int n, boolean bl) {
        Map<MethodSignature, CompletionItem> map = this.getMethodsInner(classNode, classNode2, string, n, 0, AccessLevel.create(classNode, classNode2), bl);
        return map;
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(ClassNode classNode, ClassNode classNode2, String string, int n) {
        Map<FieldSignature, CompletionItem> map = this.getFieldsInner(classNode, classNode2, string, n, 0);
        return map;
    }

    private Map<MethodSignature, CompletionItem> getMethodsInner(ClassNode classNode, ClassNode classNode2, String string, int n, int n2, Set<AccessLevel> set, boolean bl) {
        boolean bl2 = n2 == 0;
        Set<AccessLevel> set2 = AccessLevel.update(set, classNode, classNode2);
        HashMap<MethodSignature, CompletionItem> hashMap = new HashMap<MethodSignature, CompletionItem>();
        ClassDefinition classDefinition = this.loadDefinition(classNode2);
        ClassNode classNode3 = classDefinition.getNode();
        Map<MethodSignature, ? extends CompletionItem> map = GroovyElementHandler.forCompilationInfo(this.info).getMethods(this.index, classNode3.getName(), string, n, bl2, set, bl);
        CompleteElementHandler.fillSuggestions(map, hashMap);
        if (map.isEmpty()) {
            Object[] objectArray = new String[classNode3.isUsingGenerics() && classNode3.getGenericsTypes() != null ? classNode3.getGenericsTypes().length : 0];
            for (int i = 0; i < objectArray.length; ++i) {
                GenericsType genericsType = classNode3.getGenericsTypes()[i];
                objectArray[i] = genericsType.getUpperBounds() != null ? Utilities.translateClassLoaderTypeName(genericsType.getUpperBounds()[0].getName()) : Utilities.translateClassLoaderTypeName(genericsType.getName());
            }
            CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getMethods(classNode3.getName(), string, n, (String[])objectArray, bl2, set2, bl), hashMap);
        }
        CompleteElementHandler.fillSuggestions(MetaElementHandler.forCompilationInfo(this.info).getMethods(classNode3.getName(), string, n, bl), hashMap);
        if (classNode != null) {
            CompleteElementHandler.fillSuggestions(DynamicElementHandler.forCompilationInfo(this.info).getMethods(classNode.getName(), classNode3.getName(), string, n, bl, bl2, classDefinition.getFileObject()), hashMap);
        }
        if (classNode3.getSuperClass() != null) {
            CompleteElementHandler.fillSuggestions(this.getMethodsInner(classNode, classNode3.getSuperClass(), string, n, n2 + 1, set2, bl), hashMap);
        } else if (bl2) {
            CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getMethods("java.lang.Object", string, n, new String[0], false, set2, bl), hashMap);
        }
        for (ClassNode classNode4 : classNode3.getInterfaces()) {
            CompleteElementHandler.fillSuggestions(this.getMethodsInner(classNode, classNode4, string, n, n2 + 1, set2, bl), hashMap);
        }
        return hashMap;
    }

    private Map<FieldSignature, CompletionItem> getFieldsInner(ClassNode classNode, ClassNode classNode2, String string, int n, int n2) {
        boolean bl = n2 == 0;
        HashMap<FieldSignature, CompletionItem> hashMap = new HashMap<FieldSignature, CompletionItem>();
        ClassDefinition classDefinition = this.loadDefinition(classNode2);
        ClassNode classNode3 = classDefinition.getNode();
        CompleteElementHandler.fillSuggestions(GroovyElementHandler.forCompilationInfo(this.info).getFields(this.index, classNode3.getName(), string, n, bl), hashMap);
        CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getFields(classNode3.getName(), string, n, bl), hashMap);
        CompleteElementHandler.fillSuggestions(MetaElementHandler.forCompilationInfo(this.info).getFields(classNode3.getName(), string, n), hashMap);
        if (classNode != null) {
            CompleteElementHandler.fillSuggestions(DynamicElementHandler.forCompilationInfo(this.info).getFields(classNode.getName(), classNode3.getName(), string, n, bl, classDefinition.getFileObject()), hashMap);
        }
        if (classNode3.getSuperClass() != null) {
            CompleteElementHandler.fillSuggestions(this.getFieldsInner(classNode, classNode3.getSuperClass(), string, n, n2 + 1), hashMap);
        } else if (bl) {
            CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getFields("java.lang.Object", string, n, false), hashMap);
        }
        for (ClassNode classNode4 : classNode3.getInterfaces()) {
            CompleteElementHandler.fillSuggestions(this.getFieldsInner(classNode, classNode4, string, n, n2 + 1), hashMap);
        }
        return hashMap;
    }

    private ClassDefinition loadDefinition(ClassNode classNode) {
        IndexedClass indexedClass;
        ASTNode aSTNode;
        if (this.index == null) {
            return new ClassDefinition(classNode, null);
        }
        Set<IndexedClass> set = this.index.getClasses(classNode.getName(), QuerySupport.Kind.EXACT, true, false, false);
        if (!set.isEmpty() && (aSTNode = AstUtilities.getForeignNode(indexedClass = set.iterator().next())) instanceof ClassNode) {
            return new ClassDefinition((ClassNode)aSTNode, indexedClass);
        }
        return new ClassDefinition(classNode, null);
    }

    private static <T> void fillSuggestions(Map<T, ? extends CompletionItem> map, Map<T, ? super CompletionItem> map2) {
        for (Map.Entry<T, CompletionItem> entry : map.entrySet()) {
            if (map2.containsKey(entry.getKey())) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
    }

    private static class ClassDefinition {
        private final ClassNode node;
        private final IndexedClass indexed;

        public ClassDefinition(ClassNode classNode, IndexedClass indexedClass) {
            this.node = classNode;
            this.indexed = indexedClass;
        }

        public ClassNode getNode() {
            return this.node;
        }

        public FileObject getFileObject() {
            return this.indexed != null ? this.indexed.getFileObject() : null;
        }
    }
}

