/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.Collections;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.completion.TypeInferenceVisitor;

public class GroovyTypeAnalyzer {
    private final BaseDocument document;

    public GroovyTypeAnalyzer(BaseDocument document) {
        this.document = document;
    }

    public Set<ClassNode> getTypes(AstPath path, int astOffset) {
        ASTNode closest = path.leaf();
        if (closest instanceof VariableExpression) {
            ModuleNode moduleNode = (ModuleNode)path.root();
            TypeInferenceVisitor typeVisitor = new TypeInferenceVisitor(moduleNode.getContext(), path, this.document, astOffset);
            typeVisitor.collect();
            ClassNode guessedType = typeVisitor.getGuessedType();
            if (guessedType != null) {
                return Collections.singleton(guessedType);
            }
        }
        return Collections.emptySet();
    }
}

