/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSupport;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystem;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public abstract class RemoteFileObjectBase
extends FileObject {
    protected final RemoteFileSystem fileSystem;
    protected final ExecutionEnvironment execEnv;
    protected final String remotePath;
    protected final File cache;
    private volatile EventListenerList eventSupport;
    protected final String nameExt;
    protected final FileObject parent;

    public RemoteFileObjectBase(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, FileObject parent, String remotePath, File cache) {
        CndUtils.assertTrue((boolean)execEnv.isRemote());
        CndUtils.assertTrue((boolean)cache.exists());
        this.fileSystem = fileSystem;
        this.execEnv = execEnv;
        this.parent = parent;
        this.remotePath = RemoteFileSupport.fromFixedCaseSensitivePathIfNeeded(remotePath);
        this.cache = cache;
        int slashPos = this.remotePath.lastIndexOf(47);
        this.nameExt = slashPos < 0 ? "" : this.remotePath.substring(slashPos + 1);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    private synchronized EventListenerList getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new EventListenerList();
        }
        return this.eventSupport;
    }

    public String getPath() {
        return this.remotePath;
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        this.getEventSupport().add(FileChangeListener.class, fcl);
    }

    public FileObject createData(String name, String ext) throws IOException {
        throw new ReadOnlyException();
    }

    public FileObject createFolder(String name) throws IOException {
        throw new ReadOnlyException();
    }

    public void delete(FileLock lock) throws IOException {
        throw new ReadOnlyException();
    }

    public Object getAttribute(String attrName) {
        if (attrName.equals("java.io.File")) {
            return this.cache;
        }
        return null;
    }

    public Enumeration<String> getAttributes() {
        return Collections.enumeration(Collections.singleton("java.io.File"));
    }

    public String getExt() {
        int pointPos = this.nameExt.lastIndexOf(46);
        return pointPos < 0 ? "" : this.nameExt.substring(pointPos + 1);
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        return this.fileSystem;
    }

    protected RemoteFileSupport getRemoteFileSupport() {
        return this.fileSystem.getRemoteFileSupport();
    }

    public String getName() {
        int pointPos = this.nameExt.lastIndexOf(46);
        return pointPos < 0 ? this.nameExt : this.nameExt.substring(0, pointPos);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new ReadOnlyException();
    }

    public abstract FileObject getFileObject(String var1);

    public FileObject getParent() {
        return this.parent;
    }

    public long getSize() {
        return 1024L;
    }

    @Deprecated
    public boolean isReadOnly() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isValid() {
        return this.cache.exists();
    }

    public boolean isVirtual() {
        return !this.cache.exists();
    }

    public Date lastModified() {
        return new Date(this.cache.lastModified());
    }

    public FileLock lock() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        this.getEventSupport().remove(FileChangeListener.class, fcl);
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        throw new ReadOnlyException();
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Deprecated
    public void setImportant(boolean b) {
    }

    public String toString() {
        return this.execEnv.toString() + ":" + this.remotePath;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileObjectBase other = (RemoteFileObjectBase)((Object)obj);
        if (!(this.fileSystem == other.fileSystem || this.fileSystem != null && ((Object)((Object)this.fileSystem)).equals((Object)other.fileSystem))) {
            return false;
        }
        if (!(this.execEnv == other.execEnv || this.execEnv != null && this.execEnv.equals(other.execEnv))) {
            return false;
        }
        return this.cache == other.cache || this.cache != null && this.cache.equals(other.cache);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.fileSystem != null ? ((Object)((Object)this.fileSystem)).hashCode() : 0);
        hash = 11 * hash + (this.execEnv != null ? this.execEnv.hashCode() : 0);
        hash = 11 * hash + (this.cache != null ? this.cache.hashCode() : 0);
        return hash;
    }

    private static class ReadOnlyException
    extends IOException {
        public ReadOnlyException() {
            super("The remote file system is read-only");
        }
    }
}

