/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MainClassChooser
extends JPanel {
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private ChangeListener changeListener;
    private Collection<String> possibleMainClasses;
    private String dialogSubtitle = null;

    public MainClassChooser(FileObject[] fileObjectArray) {
        this(fileObjectArray, null);
    }

    public MainClassChooser(FileObject[] fileObjectArray, String string) {
        this.dialogSubtitle = string;
        this.initComponents();
        this.initClassesView(fileObjectArray);
    }

    public String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            return (String)this.jMainClassList.getSelectedValue();
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        return false;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListener = null;
    }

    private boolean isValidMainClassName(Object object) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(object);
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private void initClassesView(final FileObject[] fileObjectArray) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MainClassChooser.this.possibleMainClasses = SourceUtils.findMainClasses((FileObject[])fileObjectArray);
                if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                    MainClassChooser.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                } else {
                    Object[] objectArray = MainClassChooser.this.possibleMainClasses.toArray();
                    Arrays.sort(objectArray);
                    MainClassChooser.this.jMainClassList.setListData(objectArray);
                    MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                }
            }
        });
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(listSelectionEvent));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(mouseEvent));
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(380, 300));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_MainClassChooser"));
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(MainClassChooser.class).getString("CTL_AvaialableMainClasses"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_jMainClassList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }
}

