/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rubyproject.templates.NewRubyFileWizardIterator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RubyTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_NewRubyClassPrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final Project project;
    private boolean userEdit;
    private boolean fileEdited;
    private boolean classEdited;
    private String expectedExtension;
    private final List<ChangeListener> listeners;
    private NewRubyFileWizardIterator.Type type;
    private final SourceGroup[] groups;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JLabel classLabel;
    private JTextField classText;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel extendsLabel;
    private JTextField extendsText;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel moduleLabel;
    private JTextField moduleText;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;

    public RubyTargetChooserPanelGUI(Project p, SourceGroup[] groups, Component bottomPanel, NewRubyFileWizardIterator.Type type) {
        this.type = type;
        this.project = p;
        this.groups = groups;
        this.listeners = new ArrayList<ChangeListener>();
        this.userEdit = true;
        this.initComponents();
        if (type == NewRubyFileWizardIterator.Type.TEST) {
            this.extendsText.setText("Test::Unit::TestCase");
            type = this.type = NewRubyFileWizardIterator.Type.CLASS;
        }
        if (type == NewRubyFileWizardIterator.Type.CLASS || type == NewRubyFileWizardIterator.Type.MODULE) {
            if (type == NewRubyFileWizardIterator.Type.MODULE) {
                this.extendsLabel.setVisible(false);
                this.extendsText.setVisible(false);
                Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_ModuleName_Label"));
            } else {
                this.extendsText.getDocument().addDocumentListener(this);
            }
            this.moduleText.getDocument().addDocumentListener(this);
            this.classText.getDocument().addDocumentListener(this);
        } else if (type == NewRubyFileWizardIterator.Type.SPEC) {
            Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Spec_Class"));
            this.moduleLabel.setVisible(false);
            this.moduleText.setVisible(false);
            this.extendsLabel.setVisible(false);
            this.extendsText.setVisible(false);
            this.classText.getDocument().addDocumentListener(this);
        } else {
            this.classLabel.setVisible(false);
            this.classText.setVisible(false);
            this.moduleLabel.setVisible(false);
            this.moduleText.setVisible(false);
            this.extendsLabel.setVisible(false);
            this.extendsText.setVisible(false);
        }
        this.documentNameTextField.getDocument().addDocumentListener(this);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.browseButton.addActionListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(RubyTargetChooserPanelGUI.class).getString("LBL_RubyTargetChooserPanelGUI_Name"));
    }

    @Override
    public void addNotify() {
        Dimension panel2Size = this.jPanel2.getPreferredSize();
        Dimension bottomPanelSize = this.bottomPanelContainer.getPreferredSize();
        Dimension splitterSize = this.targetSeparator.getPreferredSize();
        int vmax = panel2Size.height + bottomPanelSize.height + splitterSize.height + 12;
        if (vmax > RubyTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(RubyTargetChooserPanelGUI.PREF_DIM.width, vmax));
        }
        super.addNotify();
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (template != null);
        String displayName = null;
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        SourceGroup preselectedGroup = this.getPreselectedGroup(preselectedFolder, (Boolean)template.getAttribute("isTest"));
        this.rootComboBox.setSelectedItem(preselectedGroup);
        if (preselectedFolder != null) {
            this.folderTextField.setText(FileUtil.toFile((FileObject)preselectedFolder).getPath());
        }
        if (template != null && this.documentNameTextField.getText().trim().length() == 0) {
            String prefix = NEW_CLASS_PREFIX;
            Object customPrefix = template.getAttribute("templateNamePrefix");
            if (customPrefix != null) {
                prefix = customPrefix.toString();
            }
            if (this.type != NewRubyFileWizardIterator.Type.SPEC) {
                this.documentNameTextField.setText(prefix + template.getName());
            }
            this.documentNameTextField.selectAll();
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        this.updateText();
        this.fileEdited = false;
        this.classEdited = false;
        if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.MODULE) {
            this.classText.selectAll();
        }
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return null;
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public String getClassName() {
        String text = this.classText.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public String getModuleName() {
        String text = this.moduleText.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public String getExtends() {
        String text = this.extendsText.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.classLabel = new JLabel();
        this.classText = new JTextField();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.moduleLabel = new JLabel();
        this.moduleText = new JTextField();
        this.extendsLabel = new JLabel();
        this.extendsText = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.classLabel.setLabelFor(this.classText);
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.classLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.classText, gridBagConstraints);
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_FileName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/ruby/rubyproject/templates/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_documentNameTextField"));
        this.moduleLabel.setLabelFor(this.moduleText);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_InModuleName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.moduleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.moduleText, gridBagConstraints);
        this.extendsLabel.setLabelFor(this.extendsText);
        Mnemonics.setLocalizedText((JLabel)this.extendsLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Extends_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.extendsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.extendsText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_projectTextField"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_rootComboBox"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.jPanel2.add((Component)this.folderTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.jPanel2.add((Component)this.browseButton, gridBagConstraints);
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel2.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_RubyTargetChooserPanelGUI"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            String workDir = this.folderTextField.getText();
            if (workDir.length() > 0) {
                File workdirFile = new File(workDir);
                chooser.setSelectedFile(workdirFile);
                chooser.setCurrentDirectory(workdirFile);
            }
            chooser.setDialogTitle(NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"ChooseTargetFolder"));
            if (0 == chooser.showOpenDialog(this)) {
                File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
                this.folderTextField.setText(file.getAbsolutePath());
            }
            this.updateText();
            this.fireChange();
        } else if (this.rootComboBox == e.getSource()) {
            FileObject root = ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
            this.folderTextField.setText(FileUtil.toFile((FileObject)root).getPath());
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.trackEdit(e);
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFields(JTextComponent textComponent, String value) {
        try {
            this.userEdit = false;
            textComponent.setText(value);
        }
        finally {
            this.userEdit = true;
        }
    }

    private void capitalizeFirstChar(final JTextComponent field, DocumentEvent e) {
        if (e.getType() == DocumentEvent.EventType.REMOVE) {
            return;
        }
        String text = field.getText().trim();
        if (text.length() > 0 && Character.isLowerCase(text.charAt(0))) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String text = field.getText().trim();
                    if (text.length() > 0 && Character.isLowerCase(text.charAt(0))) {
                        boolean wasEditing = RubyTargetChooserPanelGUI.this.userEdit;
                        try {
                            RubyTargetChooserPanelGUI.this.userEdit = false;
                            ((AbstractDocument)field.getDocument()).replace(0, 1, "" + Character.toUpperCase(text.charAt(0)), null);
                        }
                        catch (BadLocationException ble) {
                            Exceptions.printStackTrace((Throwable)ble);
                        }
                        finally {
                            RubyTargetChooserPanelGUI.this.userEdit = wasEditing;
                        }
                    }
                }
            });
        }
    }

    private void trackEdit(DocumentEvent e) {
        if (this.userEdit) {
            Document doc = e.getDocument();
            if (doc == this.documentNameTextField.getDocument()) {
                this.fileEdited = true;
                String text = this.documentNameTextField.getText().trim();
                if (text.length() == 0) {
                    this.fileEdited = false;
                }
                if (!(this.type != NewRubyFileWizardIterator.Type.SPEC || this.classEdited && this.classText.getText().length() != 0)) {
                    this.classEdited = false;
                    if (text.endsWith("_spec")) {
                        this.syncFields(this.classText, text.substring(0, text.length() - "_spec".length()));
                    }
                } else if (!(this.type != NewRubyFileWizardIterator.Type.CLASS && this.type != NewRubyFileWizardIterator.Type.MODULE || this.classEdited && this.classText.getText().length() != 0)) {
                    this.classEdited = false;
                    this.syncFields(this.classText, RubyUtils.underlinedNameToCamel((String)text));
                }
            } else if (doc == this.classText.getDocument()) {
                if (e.getType() != DocumentEvent.EventType.REMOVE) {
                    this.capitalizeFirstChar(this.classText, e);
                }
                this.classEdited = true;
                if (!this.fileEdited || this.documentNameTextField.getText().trim().length() == 0) {
                    this.fileEdited = false;
                    String text = this.classText.getText().trim();
                    if (this.type == NewRubyFileWizardIterator.Type.SPEC && text.length() > 0) {
                        this.syncFields(this.documentNameTextField, RubyUtils.camelToUnderlinedName((String)text) + "_spec");
                    } else {
                        this.syncFields(this.documentNameTextField, RubyUtils.camelToUnderlinedName((String)text));
                    }
                }
            } else if (doc == this.extendsText.getDocument()) {
                this.capitalizeFirstChar(this.extendsText, e);
            } else if (doc == this.moduleText.getDocument()) {
                this.capitalizeFirstChar(this.moduleText, e);
            }
        }
    }

    private void updateText() {
        String folderName = this.folderTextField.getText().trim();
        String documentName = this.documentNameTextField.getText().trim();
        if (documentName.length() > 0) {
            documentName = documentName + this.expectedExtension;
        }
        String createdFileName = folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/") + documentName;
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
    }

    private SourceGroup getPreselectedGroup(FileObject folder, Boolean isTest) {
        for (int i = 0; folder != null && i < this.groups.length; ++i) {
            FileObject root = this.groups[i].getRootFolder();
            if (!root.equals(folder) && !FileUtil.isParentOf((FileObject)root, (FileObject)folder)) continue;
            return this.groups[i];
        }
        if (isTest != null && isTest.booleanValue()) {
            for (SourceGroup group : this.groups) {
                String relPath = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)FileUtil.toFile((FileObject)group.getRootFolder()));
                if (!"test".equals(relPath) && !"test/unit".equals(relPath)) continue;
                return group;
            }
        }
        return this.groups[0];
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                SourceGroup g = (SourceGroup)value;
                super.getListCellRendererComponent((JList<?>)list, g.getDisplayName(), index, isSelected, cellHasFocus);
                this.setIcon(g.getIcon(false));
            }
            return this;
        }
    }
}

