/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiCombo;
import org.netbeans.modules.kenai.ui.KenaiDialogDescriptor;
import org.netbeans.modules.kenai.ui.KenaiFeatureCellRenderer;
import org.netbeans.modules.kenai.ui.KenaiSearchPanel;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.LoginHandleImpl;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.nodes.AddInstanceAction;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class GetSourcesFromKenaiPanel
extends JPanel {
    private SourceAccessorImpl.ProjectAndFeature prjAndFeature;
    private boolean localFolderPathEdited = false;
    private DefaultComboBoxModel comboModel;
    private Kenai kenai;
    private PropertyChangeListener listener;
    private JButton browseKenaiButton;
    private JButton browseLocalButton;
    private JButton browseRepoButton;
    private JPanel emptySpace;
    private JComboBox kenaiCombo;
    private JComboBox kenaiRepoComboBox;
    private JLabel kenaiRepoLabel;
    private JLabel localFolderDescLabel;
    private JLabel localFolderLabel;
    private JTextField localFolderTextField;
    private JLabel loggedInLabel;
    private JButton loginButton;
    private JLabel projectPreviewLabel;
    private JButton proxyConfigButton;
    private JLabel repoFolderLabel;
    private JTextField repoFolderTextField;
    private JLabel usernameLabel;

    public GetSourcesFromKenaiPanel(SourceAccessorImpl.ProjectAndFeature prjFtr) {
        this.prjAndFeature = prjFtr;
        this.initComponents();
        if (this.prjAndFeature == null) {
            this.kenai = (Kenai)this.kenaiCombo.getModel().getSelectedItem();
        } else {
            this.kenai = this.prjAndFeature.kenaiProject.getKenai();
            this.kenaiCombo.setSelectedItem(this.kenai);
        }
        this.refreshUsername();
        this.comboModel = new KenaiRepositoriesComboModel();
        this.kenaiRepoComboBox.setModel(this.comboModel);
        this.kenaiRepoComboBox.setRenderer(new KenaiFeatureCellRenderer());
        this.updatePanelUI();
        this.updateRepoPath();
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("login".equals(evt.getPropertyName())) {
                    if (GetSourcesFromKenaiPanel.this.kenai.getPasswordAuthentication() != null) {
                        GetSourcesFromKenaiPanel.this.loginButton.setEnabled(false);
                    } else {
                        GetSourcesFromKenaiPanel.this.loginButton.setEnabled(true);
                    }
                }
            }
        };
        if (this.kenai != null) {
            this.kenai.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.kenai));
        }
    }

    public GetSourcesFromKenaiPanel() {
        this((SourceAccessorImpl.ProjectAndFeature)null);
    }

    public GetSourcesInfo getSelectedSourcesInfo() {
        String[] stringArray;
        StringTokenizer stok = new StringTokenizer(this.repoFolderTextField.getText(), ",");
        ArrayList<String> repoFolders = new ArrayList<String>();
        while (stok.hasMoreTokens()) {
            repoFolders.add(stok.nextToken().trim());
        }
        if (repoFolders.size() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = repoFolders.toArray(new String[repoFolders.size()]);
        }
        String[] relPaths = stringArray;
        KenaiFeatureListItem featureItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
        return featureItem != null ? new GetSourcesInfo(featureItem.feature, this.localFolderTextField.getText(), relPaths) : null;
    }

    private void initComponents() {
        this.loggedInLabel = new JLabel();
        this.usernameLabel = new JLabel();
        this.loginButton = new JButton();
        this.kenaiRepoLabel = new JLabel();
        this.kenaiRepoComboBox = new JComboBox();
        this.browseKenaiButton = new JButton();
        this.projectPreviewLabel = new JLabel();
        this.repoFolderLabel = new JLabel();
        this.repoFolderTextField = new JTextField();
        this.browseRepoButton = new JButton();
        this.localFolderDescLabel = new JLabel();
        this.localFolderLabel = new JLabel();
        this.localFolderTextField = new JTextField();
        this.browseLocalButton = new JButton();
        this.proxyConfigButton = new JButton();
        this.emptySpace = new JPanel();
        this.kenaiCombo = new KenaiCombo(true);
        this.setBorder(BorderFactory.createEmptyBorder(10, 12, 0, 12));
        this.setPreferredSize(new Dimension(700, 250));
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.loggedInLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loggedInLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.loggedInLabel, gridBagConstraints);
        this.loggedInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loggedInLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetFromKenaiPanel.notLoggedIn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.usernameLabel.AccessibleContext.accessibleName"));
        this.usernameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.usernameLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.loginButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loginButton.text"));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.loginButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 12, 0);
        this.add((Component)this.loginButton, gridBagConstraints);
        this.loginButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loginButton.AccessibleContext.accessibleDescription"));
        this.kenaiRepoLabel.setLabelFor(this.kenaiRepoComboBox);
        Mnemonics.setLocalizedText((JLabel)this.kenaiRepoLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.kenaiRepoLabel, gridBagConstraints);
        this.kenaiRepoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoLabel.AccessibleContext.accessibleDescription"));
        this.kenaiRepoComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.kenaiRepoComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.kenaiRepoComboBox, gridBagConstraints);
        this.kenaiRepoComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoComboBox.AccessibleContext.accessibleName"));
        this.kenaiRepoComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseKenaiButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseKenaiButton.text"));
        this.browseKenaiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.browseKenaiButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.browseKenaiButton, gridBagConstraints);
        this.browseKenaiButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseKenaiButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.projectPreviewLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.projectPreviewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 16, 0);
        this.add((Component)this.projectPreviewLabel, gridBagConstraints);
        this.repoFolderLabel.setLabelFor(this.repoFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.repoFolderLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.repoFolderLabel, gridBagConstraints);
        this.repoFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderLabel.AccessibleContext.accessibleDescription"));
        this.repoFolderTextField.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.repoFolderTextField, gridBagConstraints);
        this.repoFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderTextField.AccessibleContext.accessibleName"));
        this.repoFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseRepoButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseRepoButton.text"));
        this.browseRepoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.browseRepoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.browseRepoButton, gridBagConstraints);
        this.browseRepoButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseRepoButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.localFolderDescLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.svnText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 6, 0);
        this.add((Component)this.localFolderDescLabel, gridBagConstraints);
        this.localFolderDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.AccessibleContext.accessibleDescription"));
        this.localFolderLabel.setLabelFor(this.localFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.localFolderLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.localFolderLabel, gridBagConstraints);
        this.localFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderLabel.AccessibleContext.accessibleDescription"));
        this.localFolderTextField.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderTextField.text"));
        this.localFolderTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                GetSourcesFromKenaiPanel.this.localFolderTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.localFolderTextField, gridBagConstraints);
        this.localFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderTextField.AccessibleContext.accessibleName"));
        this.localFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocalButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseLocalButton.text"));
        this.browseLocalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.browseLocalButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.browseLocalButton, gridBagConstraints);
        this.browseLocalButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseLocalButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyConfigButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.proxyConfigButton.text"));
        this.proxyConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.proxyConfigButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.proxyConfigButton, gridBagConstraints);
        this.proxyConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.proxyConfigButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.emptySpace, gridBagConstraints);
        this.kenaiCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetSourcesFromKenaiPanel.this.kenaiComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.kenaiCombo, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.AccessibleContext.accessibleDescription"));
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        boolean loginSuccess = UIUtils.showLogin(this.kenai);
        if (loginSuccess) {
            this.refreshUsername();
            KenaiTopComponent.findInstance().open();
            KenaiTopComponent.findInstance().requestActive();
        }
    }

    private void proxyConfigButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void browseKenaiButtonActionPerformed(ActionEvent evt) {
        KenaiSearchPanel browsePanel = new KenaiSearchPanel(KenaiSearchPanel.PanelType.BROWSE, false, this.kenai);
        String title = NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.BrowseKenaiProjectsTitle");
        KenaiDialogDescriptor dialogDesc = new KenaiDialogDescriptor(browsePanel, title, true, null);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
        if (NotifyDescriptor.OK_OPTION.equals(option)) {
            KenaiSearchPanel.KenaiProjectSearchInfo selProjectInfo = browsePanel.getSelectedProjectSearchInfo();
            int modelSize = this.comboModel.getSize();
            boolean inList = false;
            KenaiFeatureListItem inListItem = null;
            for (int i = 0; i < modelSize; ++i) {
                inListItem = (KenaiFeatureListItem)this.comboModel.getElementAt(i);
                if (!inListItem.project.getName().equals(selProjectInfo.kenaiProject.getName()) || !inListItem.feature.getName().equals(selProjectInfo.kenaiFeature.getName())) continue;
                inList = true;
                break;
            }
            if (selProjectInfo != null && !inList) {
                KenaiFeatureListItem item = new KenaiFeatureListItem(selProjectInfo.kenaiProject, selProjectInfo.kenaiFeature);
                this.comboModel.addElement(item);
                this.comboModel.setSelectedItem(item);
            } else if (inList && inListItem != null) {
                this.comboModel.setSelectedItem(inListItem);
            }
        }
    }

    private void browseRepoButtonActionPerformed(ActionEvent evt) {
        if (Subversion.isClientAvailable((boolean)true)) {
            String[] svnFolders;
            block6: {
                PasswordAuthentication passwdAuth = this.kenai.getPasswordAuthentication();
                KenaiFeatureListItem featureItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
                svnFolders = null;
                if (featureItem != null) {
                    String title = NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.SelectRepositoryFolderTitle");
                    String repoUrl = featureItem.feature.getLocation();
                    try {
                        svnFolders = passwdAuth != null ? Subversion.selectRepositoryFolders((String)title, (String)repoUrl, (String)passwdAuth.getUserName(), (char[])passwdAuth.getPassword()) : Subversion.selectRepositoryFolders((String)title, (String)repoUrl);
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException io) {
                        if ("SVN client unavailable".equals(io.getMessage())) break block6;
                        Exceptions.printStackTrace((Throwable)io);
                    }
                }
            }
            if (svnFolders != null) {
                this.repoFolderTextField.setText((String)svnFolders[0]);
            }
        }
    }

    private void browseLocalButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        File uFile = new File(this.localFolderTextField.getText());
        if (uFile.exists()) {
            chooser.setCurrentDirectory(FileUtil.normalizeFile((File)uFile));
        }
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selFile = chooser.getSelectedFile();
            this.localFolderTextField.setText(selFile.getAbsolutePath());
        }
    }

    private void kenaiRepoComboBoxActionPerformed(ActionEvent evt) {
        this.updatePanelUI();
        this.updateRepoPath();
    }

    private void localFolderTextFieldKeyTyped(KeyEvent evt) {
        this.localFolderPathEdited = true;
    }

    private void kenaiComboActionPerformed(ActionEvent evt) {
        final ActionEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GetSourcesFromKenaiPanel.this.kenaiCombo.getSelectedItem() != null && !(GetSourcesFromKenaiPanel.this.kenaiCombo.getSelectedItem() instanceof Kenai)) {
                    new AddInstanceAction().actionPerformed(e);
                }
                GetSourcesFromKenaiPanel.this.kenai = (Kenai)GetSourcesFromKenaiPanel.this.kenaiCombo.getSelectedItem();
                GetSourcesFromKenaiPanel.this.kenaiRepoComboBox.setModel(new KenaiRepositoriesComboModel());
                GetSourcesFromKenaiPanel.this.refreshUsername();
            }
        });
    }

    private void updatePanelUI() {
        KenaiFeatureListItem featureItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
        if (featureItem != null) {
            String serviceName = featureItem.feature.getService();
            String repositoryText = NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.RepositoryLabel");
            if ("subversion".equals(serviceName)) {
                this.enableFolderToGetUI(true);
                this.localFolderDescLabel.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.svnText"));
                this.projectPreviewLabel.setText("(" + featureItem.project.getDisplayName() + "; Subversion " + repositoryText + ")");
            } else if ("mercurial".equals(serviceName)) {
                this.enableFolderToGetUI(false);
                this.localFolderDescLabel.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.hgText"));
                this.projectPreviewLabel.setText("(" + featureItem.project.getDisplayName() + "; Mercurial " + repositoryText + ")");
            } else {
                this.enableFolderToGetUI(false);
            }
        }
    }

    private void updateRepoPath() {
        KenaiFeatureListItem selItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
        if (!this.localFolderPathEdited && selItem != null) {
            String urlString = selItem.feature.getLocation();
            String repoName = urlString.substring(urlString.lastIndexOf("/") + 1);
            this.localFolderTextField.setText(Utilities.getDefaultRepoFolder().getPath() + File.separator + repoName);
        }
    }

    private void refreshUsername() {
        PasswordAuthentication passwdAuth;
        this.setChildrenEnabled(this, this.kenai != null);
        PasswordAuthentication passwordAuthentication = passwdAuth = this.kenai == null ? null : this.kenai.getPasswordAuthentication();
        if (passwdAuth != null) {
            this.setUsername(passwdAuth.getUserName());
            this.loginButton.setEnabled(false);
        } else {
            this.setUsername(null);
            this.loginButton.setEnabled(true);
        }
    }

    private void setChildrenEnabled(Component root, boolean enabled) {
        root.setEnabled(enabled);
        if (root instanceof Container) {
            for (Component c : ((Container)root).getComponents()) {
                if (c == this.kenaiCombo) continue;
                this.setChildrenEnabled(c, enabled);
            }
        }
    }

    private void setUsername(String uName) {
        if (uName != null) {
            this.usernameLabel.setText(uName);
            this.usernameLabel.setForeground(new Color(0, 102, 0));
            this.usernameLabel.setEnabled(true);
        } else {
            this.usernameLabel.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetFromKenaiPanel.notLoggedIn"));
            this.usernameLabel.setForeground(Color.BLACK);
            this.usernameLabel.setEnabled(false);
        }
    }

    private synchronized void setComboModel(DefaultComboBoxModel model) {
        this.comboModel = model;
    }

    private synchronized DefaultComboBoxModel getComboModel() {
        return this.comboModel;
    }

    private void enableFolderToGetUI(boolean enable) {
        this.repoFolderLabel.setEnabled(enable);
        this.repoFolderTextField.setEnabled(enable);
        this.browseRepoButton.setEnabled(enable);
    }

    public static class GetSourcesInfo {
        public KenaiFeature feature;
        public String localFolderPath;
        public String[] relativePaths;

        public GetSourcesInfo(KenaiFeature ftr, String lcl, String[] rel) {
            this.feature = ftr;
            this.localFolderPath = lcl;
            this.relativePaths = rel;
        }
    }

    public static class KenaiFeatureListItem {
        KenaiProject project;
        KenaiFeature feature;

        public KenaiFeatureListItem(KenaiProject prj, KenaiFeature ftr) {
            this.project = prj;
            this.feature = ftr;
        }

        public String toString() {
            return this.feature.getLocation();
        }
    }

    private class KenaiRepositoriesComboModel
    extends DefaultComboBoxModel {
        public KenaiRepositoriesComboModel() {
            this.addOpenedProjects();
        }

        private void addOpenedProjects() {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ProjectHandle[] openedProjects;
                    for (ProjectHandle prjHandle : openedProjects = this.getOpenProjects()) {
                        KenaiProject project;
                        KenaiProject kProject = null;
                        if (prjHandle != null) {
                            kProject = prjHandle.getKenaiProject();
                        }
                        if ((project = kProject) == null) continue;
                        try {
                            KenaiFeature[] features;
                            for (final KenaiFeature feature : features = project.getFeatures(KenaiService.Type.SOURCE)) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if ("mercurial".equals(feature.getService()) || "subversion".equals(feature.getService())) {
                                            KenaiFeatureListItem item = new KenaiFeatureListItem(project, feature);
                                            KenaiRepositoriesComboModel.this.addElement(item);
                                            if (GetSourcesFromKenaiPanel.this.prjAndFeature != null && ((GetSourcesFromKenaiPanel)GetSourcesFromKenaiPanel.this).prjAndFeature.kenaiProject.getName().equals(project.getName()) && ((GetSourcesFromKenaiPanel)GetSourcesFromKenaiPanel.this).prjAndFeature.feature.equals(feature)) {
                                                KenaiRepositoriesComboModel.this.setSelectedItem(item);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (KenaiException kenaiException) {
                            Exceptions.printStackTrace((Throwable)kenaiException);
                        }
                    }
                }

                private ProjectHandle[] getOpenProjects() {
                    if (GetSourcesFromKenaiPanel.this.kenai == null) {
                        return new ProjectHandle[0];
                    }
                    String kenaiName = GetSourcesFromKenaiPanel.this.kenai.getUrl().getHost();
                    Preferences prefs = NbPreferences.forModule(DashboardImpl.class).node("allProjects" + ("kenai.com".equals(kenaiName) ? "" : "-" + kenaiName));
                    int count = prefs.getInt("count", 0);
                    ProjectHandle[] handles = new ProjectHandle[count];
                    ArrayList<String> ids = new ArrayList<String>(count);
                    for (int i = 0; i < count; ++i) {
                        String id = prefs.get("id" + i, null);
                        if (null == id || id.trim().length() <= 0) continue;
                        ids.add(id.trim());
                    }
                    HashSet<ProjectHandle> projects = new HashSet<ProjectHandle>(ids.size());
                    ProjectAccessor accessor = ProjectAccessor.getDefault();
                    for (String id : ids) {
                        ProjectHandle handle = accessor.getNonMemberProject(GetSourcesFromKenaiPanel.this.kenai, id, false);
                        if (handle == null) continue;
                        projects.add(handle);
                    }
                    PasswordAuthentication pa = GetSourcesFromKenaiPanel.this.kenai.getPasswordAuthentication();
                    if (pa != null) {
                        projects.addAll(accessor.getMemberProjects(GetSourcesFromKenaiPanel.this.kenai, new LoginHandleImpl(pa.getUserName()), false));
                    }
                    return projects.toArray(handles);
                }
            });
        }
    }
}

