/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.Iterator;
import java.util.List;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.Test;
import junit.framework.TestResult;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JUnit4TestMethodAdapter
implements Test {
    private final Class testClass;
    private final String[] methodNames;
    private final Runner runner;
    private final Cache cache;

    public JUnit4TestMethodAdapter(Class testClass, String[] methodNames) {
        if (testClass == null) {
            throw new IllegalArgumentException("testClass is <null>");
        }
        if (methodNames == null) {
            throw new IllegalArgumentException("methodNames is <null>");
        }
        for (int i = 0; i < methodNames.length; ++i) {
            if (methodNames[i] == null) {
                throw new IllegalArgumentException("method name #" + i + " is <null>");
            }
            if (methodNames[i].length() != 0) continue;
            throw new IllegalArgumentException("method name #" + i + " is empty");
        }
        this.testClass = testClass;
        this.methodNames = methodNames;
        this.cache = Cache.instance;
        Request request = methodNames.length == 1 ? Request.method((Class)testClass, (String)methodNames[0]) : Request.aClass((Class)testClass).filterWith((Filter)new MultipleMethodsFilter(testClass, methodNames));
        this.runner = request.getRunner();
    }

    public int countTestCases() {
        return this.runner.testCount();
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    public List getTests() {
        return this.cache.asTestList(this.getDescription());
    }

    public Class getTestClass() {
        return this.testClass;
    }

    public void run(TestResult result) {
        this.runner.run(this.cache.getNotifier(result));
    }

    public String toString() {
        String testClassName = this.testClass.getName();
        StringBuilder buf = new StringBuilder(testClassName.length() + 12 * this.methodNames.length).append(':');
        if (this.methodNames.length != 0) {
            buf.append(this.methodNames[0]);
            for (int i = 1; i < this.methodNames.length; ++i) {
                buf.append(',').append(this.methodNames[i]);
            }
        }
        return buf.toString();
    }

    private static final class Cache
    extends JUnit4TestAdapterCache {
        private static final Cache instance = new Cache();

        private Cache() {
        }

        public static JUnit4TestAdapterCache getDefault() {
            return instance;
        }

        public RunNotifier getNotifier(final TestResult result) {
            RunNotifier notifier = new RunNotifier();
            notifier.addListener(new RunListener(){

                public void testFailure(Failure failure) throws Exception {
                    result.addError(Cache.this.asTest(failure.getDescription()), failure.getException());
                }

                public void testFinished(Description description) throws Exception {
                    result.endTest(Cache.this.asTest(description));
                }

                public void testStarted(Description description) throws Exception {
                    result.startTest(Cache.this.asTest(description));
                }
            });
            return notifier;
        }
    }

    private static final class MultipleMethodsFilter
    extends Filter {
        private final Description methodsListDescription;
        private final Class testClass;
        private final String[] methodNames;

        private MultipleMethodsFilter(Class testClass, String[] methodNames) {
            if (testClass == null) {
                throw new IllegalArgumentException("testClass is <null>");
            }
            if (methodNames == null) {
                throw new IllegalArgumentException("methodNames is <null>");
            }
            this.methodsListDescription = Description.createSuiteDescription((Class)testClass);
            for (int i = 0; i < methodNames.length; ++i) {
                this.methodsListDescription.addChild(Description.createTestDescription((Class)testClass, (String)methodNames[i]));
            }
            this.testClass = testClass;
            this.methodNames = methodNames;
        }

        public boolean shouldRun(Description description) {
            if (this.methodNames.length == 0) {
                return false;
            }
            if (description.isTest()) {
                Iterator it = this.methodsListDescription.getChildren().iterator();
                while (it.hasNext()) {
                    Description methodDescription = (Description)it.next();
                    if (!methodDescription.equals((Object)description)) continue;
                    return true;
                }
            } else {
                Iterator it = description.getChildren().iterator();
                while (it.hasNext()) {
                    Description each = (Description)it.next();
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
            }
            return false;
        }

        public String describe() {
            StringBuilder buf = new StringBuilder(40);
            if (this.methodNames.length == 0) {
                buf.append("No methods");
            } else {
                buf.append(this.methodNames.length == 1 ? "Method" : "Methods");
                buf.append(' ');
                buf.append(this.methodNames[0]);
                for (int i = 1; i < this.methodNames.length; ++i) {
                    buf.append(',').append(this.methodNames[i]);
                }
            }
            buf.append('(').append(this.testClass.getName()).append(')');
            return buf.toString();
        }
    }
}

