/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.util.EditableProperties;

public class StoreGroup {
    private Map<String, Object[]> models;
    private Set<Document> modifiedDocuments;
    private static final int BOOLEAN_KIND_TF = 0;
    private static final int BOOLEAN_KIND_YN = 1;
    private static final int BOOLEAN_KIND_ED = 2;
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            StoreGroup.this.documentModified(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StoreGroup.this.documentModified(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StoreGroup.this.documentModified(e.getDocument());
        }
    };

    public StoreGroup() {
        this.models = new HashMap<String, Object[]>();
        this.modifiedDocuments = new HashSet<Document>();
    }

    public void store(EditableProperties editableProperties) {
        for (Map.Entry<String, Object[]> entry : this.models.entrySet()) {
            String txt;
            String key = entry.getKey();
            Object[] params = entry.getValue();
            if (params[0] instanceof ButtonModel) {
                ButtonModel model = (ButtonModel)params[0];
                boolean value = model.isSelected();
                if (params[2] == Boolean.TRUE) {
                    value = !value;
                }
                editableProperties.setProperty(key, StoreGroup.encodeBoolean(value, (Integer)params[1]));
                continue;
            }
            if (!(params[0] instanceof Document) || !this.modifiedDocuments.contains(params[0])) continue;
            Document doc = (Document)params[0];
            try {
                txt = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                txt = "";
            }
            editableProperties.setProperty(key, txt);
        }
    }

    public final JToggleButton.ToggleButtonModel createToggleButtonModel(PropertyEvaluator evaluator, String propertyName) {
        return this.createBooleanButtonModel(evaluator, propertyName, false);
    }

    public final JToggleButton.ToggleButtonModel createInverseToggleButtonModel(PropertyEvaluator evaluator, String propertyName) {
        return this.createBooleanButtonModel(evaluator, propertyName, true);
    }

    public final Document createStringDocument(PropertyEvaluator evaluator, String propertyName) {
        this.checkModelDoesNotExist(propertyName);
        String value = evaluator.getProperty(propertyName);
        if (value == null) {
            value = "";
        }
        try {
            PlainDocument d = new PlainDocument();
            d.remove(0, d.getLength());
            d.insertString(0, value, null);
            d.addDocumentListener(this.documentListener);
            this.models.put(propertyName, new Object[]{d});
            return d;
        }
        catch (BadLocationException e) {
            assert (false) : "Bad location exception from new document.";
            return new PlainDocument();
        }
    }

    private void checkModelDoesNotExist(String propertyName) {
        if (this.models.get(propertyName) != null) {
            throw new IllegalArgumentException("Model for property " + propertyName + "already exists.");
        }
    }

    private final JToggleButton.ToggleButtonModel createBooleanButtonModel(PropertyEvaluator evaluator, String propName, boolean invert) {
        this.checkModelDoesNotExist(propName);
        String value = evaluator.getProperty(propName);
        boolean isSelected = false;
        Integer kind = 0;
        if (value != null) {
            String lowercaseValue = value.toLowerCase();
            if (lowercaseValue.equals("yes") || lowercaseValue.equals("no")) {
                kind = 1;
            } else if (lowercaseValue.equals("on") || lowercaseValue.equals("off")) {
                kind = 2;
            }
            if (lowercaseValue.equals("true") || lowercaseValue.equals("yes") || lowercaseValue.equals("on")) {
                isSelected = true;
            }
        }
        JToggleButton.ToggleButtonModel bm = new JToggleButton.ToggleButtonModel();
        bm.setSelected(invert ? !isSelected : isSelected);
        this.models.put(propName, new Object[]{bm, kind, invert});
        return bm;
    }

    private static String encodeBoolean(boolean value, Integer kind) {
        if (kind == 2) {
            return value ? "on" : "off";
        }
        if (kind == 1) {
            return value ? "yes" : "no";
        }
        return value ? "true" : "false";
    }

    private void documentModified(Document d) {
        this.modifiedDocuments.add(d);
    }
}

