/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.serialization;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterDeserializer;
import org.netbeans.modules.vmd.api.properties.DefaultPropertiesPresenter;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertiesCategories;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorBooleanUC;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorJavaString;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorString;
import org.netbeans.modules.vmd.midp.serialization.XMLUtils;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class MidpPropertyPresenterDeserializer
extends PresenterDeserializer {
    public static final String PROPERTY_NODE = "MidpProperty";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String EDITOR_ATTR = "editor";
    public static final String PROPERTY_NAME_ATTR = "propertyName";
    public static final String EDITOR_BOOLEAN = "boolean";
    public static final String EDITOR_CHAR = "char";
    public static final String EDITOR_BYTE = "byte";
    public static final String EDITOR_SHORT = "short";
    public static final String EDITOR_INT = "int";
    public static final String EDITOR_LONG = "long";
    public static final String EDITOR_FLOAT = "float";
    public static final String EDITOR_DOUBLE = "double";
    public static final String EDITOR_STRING = "java.lang.String";
    public static final String EDITOR_JAVA_CODE = "#javaCode";

    public MidpPropertyPresenterDeserializer() {
        super("vmd-midp");
    }

    public PresenterDeserializer.PresenterFactory deserialize(Node node) {
        if (!PROPERTY_NODE.equalsIgnoreCase(node.getNodeName())) {
            return null;
        }
        String displayName = XMLUtils.getAttributeValue(node, DISPLAY_NAME_ATTR);
        String editor = XMLUtils.getAttributeValue(node, EDITOR_ATTR);
        String propertyName = XMLUtils.getAttributeValue(node, PROPERTY_NAME_ATTR);
        return new MidpPropertyPresenterFactory(displayName, editor, propertyName);
    }

    private static class MidpPropertyPresenterFactory
    extends PresenterDeserializer.PresenterFactory {
        private String displayName;
        private String editor;
        private String propertyName;

        public MidpPropertyPresenterFactory(String displayName, String editor, String propertyName) {
            this.displayName = displayName;
            this.editor = editor;
            this.propertyName = propertyName;
        }

        public List<Presenter> createPresenters(ComponentDescriptor descriptor) {
            DefaultPropertiesPresenter presenter = new DefaultPropertiesPresenter().addPropertiesCategory(MidpPropertiesCategories.CATEGORY_PROPERTIES);
            if (MidpPropertyPresenterDeserializer.EDITOR_BOOLEAN.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorBooleanUC.createInstance(), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_INT.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createIntegerInstance(false, NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_INTEGER_STR")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_FLOAT.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createFloatInstance(NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_FLOAT_STR")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_STRING.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorString.createInstance(NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_STRING")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_JAVA_CODE.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorJavaString.createInstance(descriptor.getTypeDescriptor().getThisType()), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_CHAR.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createCharInstance(false, NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_CHAR_STR")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_BYTE.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createByteInstance(false, NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_BYTE_STR")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_SHORT.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createShortInstance(false, NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_SHORT_STR")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_LONG.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createLongInstance(false, NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_LONG_STR")), new String[]{this.propertyName});
            } else if (MidpPropertyPresenterDeserializer.EDITOR_DOUBLE.equals(this.editor)) {
                presenter.addProperty(this.displayName, (DesignPropertyEditor)PropertyEditorNumber.createDoubleInstance(NbBundle.getMessage(MidpPropertyPresenterDeserializer.class, (String)"LBL_DOUBLE_STR")), new String[]{this.propertyName});
            } else {
                return null;
            }
            return Arrays.asList(presenter);
        }
    }
}

