/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorGaugeMaxValue;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorPreferredSize;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorNumber
extends PropertyEditorUserCode
implements PropertyEditorElement {
    public static final String NON_DIGITS_TEXT = NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"MSG_NON_DIGIT_CHARS");
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private String label;
    private boolean positiveNumersOnly;
    private boolean useSpinner;

    private PropertyEditorNumber(boolean useSpinner, String label, String userCodeLabel) {
        super(userCodeLabel);
        this.label = label;
        this.useSpinner = useSpinner;
    }

    private PropertyEditorNumber(boolean useSpinner, String label, String userCodeLabel, boolean positiveNumbersOnly) {
        super(userCodeLabel);
        this.label = label;
        this.positiveNumersOnly = positiveNumbersOnly;
        this.useSpinner = useSpinner;
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
    }

    public static final PropertyEditorNumber createIntegerInstance(boolean useSpinner, String label) {
        return new PropertyEditorNumber(useSpinner, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_INTEGER_UCLABEL"));
    }

    public static final PropertyEditorNumber createPositiveIntegerInstance(boolean useSpinner, String label) {
        return new PropertyEditorNumber(useSpinner, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_INTEGER_UCLABEL"), true);
    }

    public static final PropertyEditorNumber createLongInstance(boolean useSpinner, String label) {
        return new PropertyEditorNumber(useSpinner, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_LONG_UCLABEL")){

            @Override
            protected void saveValue(String text) {
                if (text.length() > 0) {
                    long longValue = 0L;
                    try {
                        text = this.prepareText(text);
                        longValue = Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createLongValue(longValue));
                }
            }
        };
    }

    public static final PropertyEditorNumber createByteInstance(boolean useSpinner, String label) {
        return new PropertyEditorNumber(useSpinner, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_BYTE_UCLABEL")){

            @Override
            protected void saveValue(String text) {
                if (text.length() > 0) {
                    byte byteValue = 0;
                    try {
                        text = this.prepareText(text);
                        byteValue = Byte.parseByte(text);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createByteValue(byteValue));
                }
            }
        };
    }

    public static final PropertyEditorNumber createShortInstance(boolean useSpinner, String label) {
        return new PropertyEditorNumber(useSpinner, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_SHORT_UCLABEL")){

            @Override
            protected void saveValue(String text) {
                if (text.length() > 0) {
                    short shortValue = 0;
                    try {
                        text = this.prepareText(text);
                        shortValue = Short.parseShort(text);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createShortValue(shortValue));
                }
            }
        };
    }

    public static final PropertyEditorNumber createFloatInstance(String label) {
        return new PropertyEditorNumber(false, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_FLOAT_UCLABEL")){

            @Override
            protected boolean isTextCorrect(String text) {
                return Pattern.matches("[\\d\\-\\.]+", text);
            }

            @Override
            protected String prepareText(String text) {
                return text.replaceAll("[^0-9\\-\\.]+", "");
            }

            @Override
            protected void saveValue(String text) {
                if (text.length() > 0) {
                    float floatValue = 0.0f;
                    try {
                        text = this.prepareText(text);
                        floatValue = Float.parseFloat(text);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createFloatValue(floatValue));
                }
            }
        };
    }

    public static final PropertyEditorNumber createDoubleInstance(String label) {
        return new PropertyEditorNumber(false, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_DOUBLE_UCLABEL")){

            @Override
            protected boolean isTextCorrect(String text) {
                return Pattern.matches("[\\d\\-\\.]+", text);
            }

            @Override
            protected String prepareText(String text) {
                return text.replaceAll("[^0-9\\-\\.]+", "");
            }

            @Override
            protected void saveValue(String text) {
                if (text.length() > 0) {
                    double doubleValue = 0.0;
                    try {
                        text = this.prepareText(text);
                        doubleValue = Double.parseDouble(text);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createDoubleValue(doubleValue));
                }
            }
        };
    }

    public static final PropertyEditorNumber createCharInstance(boolean useSpinner, String label) {
        return new PropertyEditorNumber(useSpinner, label, NbBundle.getMessage(PropertyEditorNumber.class, (String)"LBL_CHAR_UCLABEL")){

            @Override
            protected boolean isTextCorrect(String text) {
                return Pattern.matches("[\\d\\-]+", text);
            }

            @Override
            protected String prepareText(String text) {
                return text.replaceAll("[^0-9\\-]+", "");
            }

            @Override
            protected void saveValue(String text) {
                if (text.length() > 0) {
                    char charValue = '\u0000';
                    try {
                        text = this.prepareText(text);
                        charValue = text.charAt(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    super.setValue((Object)MidpTypes.createCharValue(charValue));
                }
            }
        };
    }

    private void initComponents(boolean useSpinner) {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor(useSpinner);
    }

    protected boolean isTextCorrect(String text) {
        return Pattern.matches("[\\d\\-]+", text) || this.isHexFormat(text);
    }

    protected String prepareText(String text) {
        if (text == null) {
            return text;
        }
        if (this.isHexFormat(text)) {
            text = text.replaceAll("[^0-9\\-0xabcdefABCDEF]+", "");
            return text.replace("0x", "");
        }
        return text.replaceAll("[^0-9\\-]+", "");
    }

    protected void saveValue(String text) {
        if (text.length() > 0) {
            int intValue = 0;
            try {
                if (this.isHexFormat(text)) {
                    text = this.prepareText(text);
                    intValue = Integer.parseInt(text, 16);
                } else {
                    text = this.prepareText(text);
                    intValue = Integer.parseInt(text);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.positiveNumersOnly && intValue < 0) {
                intValue = 0;
            }
            super.setValue((Object)MidpTypes.createIntegerValue(intValue));
        }
    }

    private boolean isHexFormat(String text) {
        return text != null && text.matches("-?0x[\\d\\abcdefABCDEF]+");
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return String.valueOf(value.getPrimitiveValue());
    }

    @Override
    public void setAsText(String text) {
        if (this.canEditAsText().booleanValue()) {
            this.saveValue(text);
        }
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setText(null);
        } else {
            this.customEditor.setText(String.valueOf(value.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents(this.useSpinner);
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements DocumentListener,
    ChangeListener,
    FocusListener {
        private JTextField textField;
        private JSpinner spinner;
        private boolean useSpinner;

        public CustomEditor(boolean useSpinner) {
            this.useSpinner = useSpinner;
            PropertyEditorNumber.this.radioButton.addFocusListener(this);
            this.initComponents();
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent evt) {
                    JDialog dialog = CustomEditor.this.getDialog();
                    if (dialog == null) {
                        return;
                    }
                    dialog.getAccessibleContext().setAccessibleName(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleName());
                    dialog.getAccessibleContext().setAccessibleDescription(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
                }
            });
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.spinner = null;
            this.removeAll();
        }

        private JDialog getDialog() {
            Container comp = this;
            while ((comp = comp.getParent()) != null) {
                if (!(comp instanceof JDialog)) continue;
                return (JDialog)comp;
            }
            return null;
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            if (this.useSpinner) {
                this.spinner = new JSpinner();
                this.spinner.getModel().addChangeListener(this);
                this.spinner.addFocusListener(this);
                this.add((Component)this.spinner, "Center");
                this.spinner.getAccessibleContext().setAccessibleName(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleName());
                this.spinner.getAccessibleContext().setAccessibleDescription(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
            } else {
                this.textField = new JTextField();
                this.textField.getDocument().addDocumentListener(this);
                this.textField.addFocusListener(this);
                this.add((Component)this.textField, "Center");
                this.textField.getAccessibleContext().setAccessibleName(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleName());
                this.textField.getAccessibleContext().setAccessibleDescription(PropertyEditorNumber.this.radioButton.getAccessibleContext().getAccessibleDescription());
            }
        }

        public void setText(String text) {
            if (this.useSpinner) {
                Integer intValue = 0;
                try {
                    if (PropertyEditorNumber.this.isHexFormat(text)) {
                        text = PropertyEditorNumber.this.prepareText(text);
                        intValue = Integer.parseInt(text, 16);
                    } else {
                        text = PropertyEditorNumber.this.prepareText(text);
                        intValue = Integer.parseInt(text);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.spinner.setValue(intValue);
            } else {
                this.textField.setText(text);
            }
        }

        public String getText() {
            return this.useSpinner ? this.spinner.getValue().toString() : this.textField.getText();
        }

        private void checkNumberStatus() {
            if (!PropertyEditorNumber.this.isTextCorrect(this.getText())) {
                PropertyEditorNumber.this.displayWarning(NON_DIGITS_TEXT);
                return;
            }
            if (PropertyEditorNumber.this.positiveNumersOnly) {
                try {
                    int number = Integer.valueOf(this.textField.getText());
                    if (number < 0) {
                        PropertyEditorNumber.this.displayWarning(NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"MSG_POSITIVE_CHARS"));
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    PropertyEditorNumber.this.displayWarning(NON_DIGITS_TEXT);
                    return;
                }
            }
            PropertyEditorNumber.this.clearErrorStatus();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == this.textField || e.getSource() == this.spinner) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            PropertyEditorNumber.this.clearErrorStatus();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.spinner.hasFocus()) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (this.textField.hasFocus()) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.textField.hasFocus()) {
                PropertyEditorNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

