/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptorFactory;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public final class MidpPrimitiveDescriptor
implements PrimitiveDescriptorFactory {
    static final CharPD charPD = new CharPD();
    static final BytePD bytePD = new BytePD();
    static final ShortPD shortPD = new ShortPD();
    static final IntPD intPD = new IntPD();
    static final LongPD longPD = new LongPD();
    static final FloatPD floatPD = new FloatPD();
    static final DoublePD doublePD = new DoublePD();
    static final StringPD stringPD = new StringPD();
    static final BooleanPD booleanPD = new BooleanPD();

    public String getProjectType() {
        return "vmd-midp";
    }

    public PrimitiveDescriptor getDescriptorForTypeIDString(String string) {
        if (MidpTypes.TYPEID_CHAR.getString().equals(string)) {
            return intPD;
        }
        if (MidpTypes.TYPEID_BYTE.getString().equals(string)) {
            return bytePD;
        }
        if (MidpTypes.TYPEID_SHORT.getString().equals(string)) {
            return shortPD;
        }
        if (MidpTypes.TYPEID_INT.getString().equals(string)) {
            return intPD;
        }
        if (MidpTypes.TYPEID_LONG.getString().equals(string)) {
            return longPD;
        }
        if (MidpTypes.TYPEID_FLOAT.getString().equals(string)) {
            return floatPD;
        }
        if (MidpTypes.TYPEID_DOUBLE.getString().equals(string)) {
            return doublePD;
        }
        if (MidpTypes.TYPEID_BOOLEAN.getString().equals(string)) {
            return booleanPD;
        }
        if (MidpTypes.TYPEID_JAVA_LANG_STRING.getString().equals(string)) {
            return stringPD;
        }
        if (MidpTypes.TYPEID_JAVA_CODE.getString().equals(string)) {
            return stringPD;
        }
        return null;
    }

    private static class StringPD
    implements PrimitiveDescriptor {
        private StringPD() {
        }

        public String serialize(Object value) {
            return (String)value;
        }

        public Object deserialize(String serialized) {
            return serialized;
        }

        public boolean isValidInstance(Object object) {
            return object instanceof String;
        }
    }

    private static class BooleanPD
    implements PrimitiveDescriptor {
        private BooleanPD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Boolean.parseBoolean(serialized);
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Boolean;
        }
    }

    private static class DoublePD
    implements PrimitiveDescriptor {
        private DoublePD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Double.parseDouble(serialized);
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Double;
        }
    }

    private static class FloatPD
    implements PrimitiveDescriptor {
        private FloatPD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Float.valueOf(Float.parseFloat(serialized));
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Float;
        }
    }

    private static class LongPD
    implements PrimitiveDescriptor {
        private LongPD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Long.parseLong(serialized);
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Long;
        }
    }

    private static class IntPD
    implements PrimitiveDescriptor {
        private IntPD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Integer.parseInt(serialized);
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Integer;
        }
    }

    private static class ShortPD
    implements PrimitiveDescriptor {
        private ShortPD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Short.parseShort(serialized);
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Short;
        }
    }

    private static class BytePD
    implements PrimitiveDescriptor {
        private BytePD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Byte.parseByte(serialized);
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Byte;
        }
    }

    private static class CharPD
    implements PrimitiveDescriptor {
        private CharPD() {
        }

        public String serialize(Object value) {
            return value.toString();
        }

        public Object deserialize(String serialized) {
            return Character.valueOf(serialized.charAt(0));
        }

        public boolean isValidInstance(Object object) {
            return object instanceof Character;
        }
    }
}

