/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess.transparency;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public class RasterRangesUtils {
    private static final int[] subColMasks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    public static boolean outputOccupiedRanges(Raster raster, RangesOutput out) {
        DataBuffer data;
        boolean hasAlpha;
        Rectangle bounds = raster.getBounds();
        SampleModel sampleModel = raster.getSampleModel();
        boolean bl = hasAlpha = sampleModel.getNumBands() == 4;
        if (raster.getParent() == null && bounds.x == 0 && bounds.y == 0 && (data = raster.getDataBuffer()).getNumBanks() == 1) {
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel packedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (packedSampleModel.getPixelBitStride() == 1) {
                    return RasterRangesUtils.outputOccupiedRangesOfBinaryPixels(((DataBufferByte)data).getData(), bounds.width, bounds.height, out);
                }
            } else if (sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getDataType() == 3) {
                return RasterRangesUtils.outputOccupiedRanges(((DataBufferInt)data).getData(), bounds.width, bounds.height, hasAlpha ? -16777216 : 0xFFFFFF, out);
            }
        }
        int[] pixels = raster.getPixels(0, 0, bounds.width, bounds.height, (int[])null);
        return RasterRangesUtils.outputOccupiedRanges(pixels, bounds.width, bounds.height, hasAlpha ? -16777216 : 0xFFFFFF, out);
    }

    public static boolean outputOccupiedRangesOfBinaryPixels(byte[] binaryBits, int w, int h, RangesOutput output) {
        int scanlineBytes = binaryBits.length / h;
        for (int row = 0; row < h; ++row) {
            int rowOffsetBytes = row * scanlineBytes;
            int startCol = -1;
            for (int byteCol = 0; byteCol < scanlineBytes; ++byteCol) {
                int firstByteCol = byteCol << 3;
                byte byteColBits = binaryBits[rowOffsetBytes + byteCol];
                if (byteColBits == 0) {
                    if (startCol < 0) continue;
                    if (!output.outputRange(startCol, row, firstByteCol - startCol, 1)) {
                        return false;
                    }
                    startCol = -1;
                    continue;
                }
                if (byteColBits == 255) {
                    if (startCol >= 0) continue;
                    startCol = firstByteCol;
                    continue;
                }
                for (int subCol = 0; subCol < 8; ++subCol) {
                    int col = firstByteCol | subCol;
                    if ((byteColBits & subColMasks[subCol]) != 0) {
                        if (startCol >= 0) continue;
                        startCol = col;
                        continue;
                    }
                    if (startCol < 0) continue;
                    if (!output.outputRange(startCol, row, col - startCol, 1)) {
                        return false;
                    }
                    startCol = -1;
                }
            }
            if (startCol < 0) continue;
            if (!output.outputRange(startCol, row, w - startCol, 1)) {
                return false;
            }
            startCol = -1;
        }
        return true;
    }

    public static boolean outputOccupiedRanges(int[] pixels, int w, int h, int occupationMask, RangesOutput out) {
        for (int row = 0; row < h; ++row) {
            int idxOffset = row * w;
            int startCol = -1;
            for (int col = 0; col < w; ++col) {
                if ((pixels[idxOffset + col] & occupationMask) != 0) {
                    if (startCol >= 0) continue;
                    startCol = col;
                    continue;
                }
                if (startCol < 0) continue;
                if (!out.outputRange(startCol, row, col - startCol, 1)) {
                    return false;
                }
                startCol = -1;
            }
            if (startCol < 0) continue;
            if (!out.outputRange(startCol, row, w - startCol, 1)) {
                return false;
            }
            startCol = -1;
        }
        return true;
    }

    public static interface RangesOutput {
        public boolean outputRange(int var1, int var2, int var3, int var4);
    }
}

