/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.makefile;

import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public abstract class MakefileElement {
    private final Kind kind;
    private final FileObject fileObject;
    private final int startOffset;
    private final int endOffset;

    MakefileElement(Kind kind, FileObject fileObject, int startOffset, int endOffset) {
        Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (endOffset < startOffset) {
            throw new IllegalArgumentException(String.format("endOffset:%d < startOffset:%d", endOffset, startOffset));
        }
        this.kind = kind;
        this.fileObject = fileObject;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public final Kind getKind() {
        return this.kind;
    }

    public final FileObject getContainingFile() {
        return this.fileObject;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        MACRO,
        RULE,
        INCLUDE;

    }
}

