/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.dlight.annotationsupport.FileAnnotationInfo;

public final class LineAnnotationInfo {
    private static String SPACES = "                               ";
    private FileAnnotationInfo fileAnnotationInfo;
    private int line;
    private long offset;
    private long lineOffset = -1L;
    private String annotation;
    private String tooltip;
    private String[] columns;
    private String[] notFormatedColumns;
    private Position position;
    private int y1;
    private int y2;

    public LineAnnotationInfo(FileAnnotationInfo fileAnnotationInfo) {
        this.fileAnnotationInfo = fileAnnotationInfo;
        this.annotation = null;
    }

    public int getLine() {
        if (this.line < 0) {
            try {
                this.line = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.getFileAnnotationInfo().getEditorPane().getDocument()), (int)((int)this.offset));
                ++this.line;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.line;
    }

    public long getOffset() {
        if (this.offset < 0L) {
            Element el = this.fileAnnotationInfo.getEditorPane().getDocument().getDefaultRootElement().getElement(this.line - 1);
            this.offset = el.getStartOffset();
        }
        return this.offset;
    }

    public long getLineOffset() {
        if (this.lineOffset <= 0L) {
            try {
                Element el = this.fileAnnotationInfo.getEditorPane().getDocument().getDefaultRootElement().getElement(this.getLine() - 1);
                this.lineOffset = el.getStartOffset();
            }
            catch (IndexOutOfBoundsException ioobe) {
                return 0L;
            }
        }
        return this.lineOffset;
    }

    public Position getPosition() {
        if (this.position == null) {
            try {
                this.position = this.fileAnnotationInfo.getEditorPane().getDocument().createPosition((int)this.getLineOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.position;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getAnnotation() {
        this.annotation = "";
        int col = 0;
        for (String metric : this.getColumns()) {
            int maxColumnWith = this.getFileAnnotationInfo().getMaxColumnWidth()[col];
            String formattedMetric = SPACES.substring(0, maxColumnWith - metric.length()) + metric;
            if (this.annotation.length() > 0) {
                this.annotation = this.annotation + " | ";
            }
            this.annotation = this.annotation + formattedMetric;
            ++col;
        }
        return this.annotation;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public FileAnnotationInfo getFileAnnotationInfo() {
        return this.fileAnnotationInfo;
    }

    public void setFileAnnotationInfo(FileAnnotationInfo fileAnnotationInfo) {
        this.fileAnnotationInfo = fileAnnotationInfo;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String[] getNotFormattedColumns() {
        return this.notFormatedColumns;
    }

    public void setNotFormattedColumns(String[] columns) {
        this.notFormatedColumns = columns;
    }

    public synchronized String getTooltip() {
        if (this.tooltip == null) {
            if (this.notFormatedColumns == null || this.notFormatedColumns.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            int i = 0;
            for (String col : this.getFileAnnotationInfo().getColumnNames()) {
                if (i > 0) {
                    sb.append("<br>");
                }
                sb.append(col).append(':').append(this.notFormatedColumns[i]);
                ++i;
            }
            sb.append("</body></html>");
            this.tooltip = sb.toString();
        }
        return this.tooltip;
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY(int y1, int y2) {
        this.y1 = y1;
        this.y2 = y2;
    }

    public String toString() {
        return this.getTooltip();
    }
}

