/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultWindow;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public final class Manager {
    private static Reference<Manager> instanceRef;
    private final Set<TestSession> testSessions = new WeakSet(5);
    private final boolean lateWindowPromotion;
    private static final Logger LOGGER;
    private Map<TestSession, ResultDisplayHandler> displayHandlers;
    private Map<TestSession, Boolean> displaysMap;

    public static Manager getInstance() {
        if (instanceRef != null && instanceRef.get() != null) {
            return instanceRef.get();
        }
        final Manager instance = new Manager();
        ResultWindow.getInstance().addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                instance.updateDisplayHandlerLayouts();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                instance.updateDisplayHandlerLayouts();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                instance.updateDisplayHandlerLayouts();
            }
        });
        instanceRef = new WeakReference<Manager>(instance);
        return instance;
    }

    private void updateDisplayHandlerLayouts() {
        int y;
        int x = ResultWindow.getInstance().getWidth();
        int orientation = x > (y = ResultWindow.getInstance().getHeight()) ? 1 : 0;
        ResultWindow.getInstance().setOrientation(orientation);
    }

    private Manager() {
        this.lateWindowPromotion = true;
    }

    public synchronized void emptyTestRun(TestSession session) {
        this.testStarted(session);
        this.sessionFinished(session);
    }

    public synchronized void testStarted(TestSession session) {
        this.displayMessage(session, NbBundle.getMessage(this.getClass(), (String)"LBL_RunningTests"));
        if (session.getStartingMsg() != null) {
            this.displayOutput(session, session.getStartingMsg(), true);
        }
    }

    public synchronized void sessionFinished(TestSession session) {
        if (!this.testSessions.contains(session)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Finishing an unknown session: " + session);
            }
            return;
        }
        this.displayMessage(session, null, true);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Finishing session: " + session);
        }
        this.testSessions.remove(session);
    }

    public synchronized void displayOutput(TestSession session, String text, boolean error) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayOutput(text, error);
        this.displayInWindow(session, displayHandler);
    }

    public synchronized void displaySuiteRunning(TestSession session, String suiteName) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displaySuiteRunning(suiteName);
        this.displayInWindow(session, displayHandler);
    }

    public synchronized void displaySuiteRunning(TestSession session, TestSuite suite) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displaySuiteRunning(suite);
        this.displayInWindow(session, displayHandler);
    }

    public void displayReport(TestSession session, Report report) {
        this.displayReport(session, report, true);
    }

    public synchronized void displayReport(TestSession session, Report report, boolean completed) {
        report.completed = completed;
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayReport(report);
        this.displayInWindow(session, displayHandler);
    }

    private void displayMessage(TestSession session, String message) {
        this.displayMessage(session, message, false);
    }

    private void displayMessage(TestSession session, String message, boolean sessionEnd) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        this.displayInWindow(session, displayHandler, sessionEnd);
        if (!sessionEnd) {
            displayHandler.displayMessage(message);
        } else {
            displayHandler.displayMessageSessionFinished(message);
        }
    }

    private void displayInWindow(TestSession session, ResultDisplayHandler displayHandler) {
        this.displayInWindow(session, displayHandler, false);
    }

    private void displayInWindow(TestSession session, ResultDisplayHandler displayHandler, boolean sessionEnd) {
        boolean firstDisplay;
        boolean bl = firstDisplay = this.testSessions.add(session);
        boolean promote = session.getSessionType() == TestSession.SessionType.TEST ? firstDisplay || sessionEnd : sessionEnd;
        int displayIndex = this.getDisplayIndex(session);
        if (displayIndex == -1) {
            this.addDisplay(session);
            Mutex.EVENT.writeAccess((Runnable)new Displayer(displayHandler, promote));
        } else if (promote) {
            Mutex.EVENT.writeAccess((Runnable)new Displayer(null, promote));
        }
    }

    private synchronized ResultDisplayHandler getDisplayHandler(TestSession session) {
        ResultDisplayHandler displayHandler;
        ResultDisplayHandler resultDisplayHandler = displayHandler = this.displayHandlers != null ? this.displayHandlers.get(session) : null;
        if (displayHandler == null) {
            if (this.displayHandlers == null) {
                this.displayHandlers = new WeakHashMap<TestSession, ResultDisplayHandler>(7);
            }
            displayHandler = new ResultDisplayHandler(session);
            this.createIO(displayHandler);
            this.displayHandlers.put(session, displayHandler);
        }
        return displayHandler;
    }

    private void createIO(final ResultDisplayHandler displayHandler) {
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ResultWindow window = ResultWindow.getInstance();
                    window.addDisplayComponent(displayHandler.getDisplayComponent(), displayHandler.getLookup());
                    window.setOutputComp(displayHandler.getOutputComponent());
                    displayHandler.createIO(window.getIOContainer());
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int getDisplayIndex(TestSession session) {
        if (this.displaysMap == null) {
            return -1;
        }
        Boolean o = this.displaysMap.get(session);
        return o != null ? 0 : -1;
    }

    private void addDisplay(TestSession session) {
        if (this.displaysMap == null) {
            this.displaysMap = new WeakHashMap<TestSession, Boolean>(4);
        }
        this.displaysMap.put(session, Boolean.TRUE);
    }

    static {
        LOGGER = Logger.getLogger(Manager.class.getName());
    }

    private class Displayer
    implements Runnable {
        private final ResultDisplayHandler displayHandler;
        private final boolean promote;

        Displayer(ResultDisplayHandler displayHandler, boolean promote) {
            this.displayHandler = displayHandler;
            this.promote = promote;
        }

        @Override
        public void run() {
            ResultWindow window = ResultWindow.getInstance();
            if (this.promote) {
                window.promote();
            }
        }
    }
}

