/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.ClassViewModel;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.HostKeyArray;
import org.netbeans.modules.cnd.classview.NamespaceKeyArray;
import org.netbeans.modules.cnd.classview.SortedName;
import org.netbeans.modules.cnd.classview.model.ProjectNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ProjectsKeyArray
extends Children.Keys<CsmProject> {
    private Map<CsmProject, SortedName> myProjects;
    private ChildrenUpdater childrenUpdater;
    private static Comparator<Map.Entry<CsmProject, SortedName>> COMARATOR = new ProjectComparator();
    private final Object lock = new Object();

    public ProjectsKeyArray(ChildrenUpdater childrenUpdater) {
        this.childrenUpdater = childrenUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeys() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                ArrayList<Map.Entry<CsmProject, SortedName>> list = new ArrayList<Map.Entry<CsmProject, SortedName>>(this.myProjects.entrySet());
                Collections.sort(list, COMARATOR);
                ArrayList<CsmProject> res = new ArrayList<CsmProject>();
                for (Map.Entry entry : list) {
                    CsmProject key = (CsmProject)entry.getKey();
                    res.add(key);
                }
                this.setKeys(res);
            } else {
                this.setKeys(Collections.emptyList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                this.myProjects.clear();
            }
        }
        this.childrenUpdater = null;
        this.setKeys(new CsmProject[0]);
    }

    private Set<CsmProject> getProjects() {
        HashSet<CsmProject> projects = new HashSet<CsmProject>();
        for (CsmProject p : CsmModelAccessor.getModel().projects()) {
            if (ClassViewModel.isShowLibs()) {
                for (CsmProject lib : p.getLibraries()) {
                    projects.add(lib);
                }
            }
            projects.add(p);
        }
        return projects;
    }

    private SortedName getSortedName(CsmProject project, boolean isLibrary) {
        if (isLibrary) {
            return new SortedName(1, project.getName(), 0);
        }
        return new SortedName(0, project.getName(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                return this.myProjects.size() == 0;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(CsmProject project) {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects == null) {
                return;
            }
            if (this.myProjects.containsKey(project)) {
                return;
            }
            this.myProjects.put(project, this.getSortedName(project, false));
        }
        this.resetKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProject(CsmProject project) {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects == null || this.myProjects.size() == 0) {
                return;
            }
            if (!this.myProjects.containsKey(project)) {
                return;
            }
            this.myProjects.remove(project);
            this.childrenUpdater.unregister(project);
            boolean removeAll = true;
            for (CsmProject p : this.myProjects.keySet()) {
                SortedName name = this.myProjects.get(p);
                if (name == null || name.getPrefix() != 0) continue;
                removeAll = false;
                break;
            }
            if (removeAll) {
                for (CsmProject p : this.myProjects.keySet()) {
                    this.childrenUpdater.unregister(p);
                }
                this.myProjects.clear();
            }
        }
        this.resetKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjects() {
        Set<CsmProject> newProjects = this.getProjects();
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                for (CsmProject p : this.myProjects.keySet()) {
                    if (newProjects.contains(p)) continue;
                    this.childrenUpdater.unregister(p);
                }
            }
            this.myProjects = this.createProjectsMap();
            for (CsmProject p : newProjects) {
                this.myProjects.put(p, this.getSortedName(p, false));
            }
        }
        this.resetKeys();
    }

    private Map<CsmProject, SortedName> createProjectsMap() {
        return new ConcurrentHashMap<CsmProject, SortedName>();
    }

    protected Node[] createNodes(CsmProject project) {
        ProjectNode node = null;
        try {
            node = new ProjectNode(project, (Children.Array)new NamespaceKeyArray(this.childrenUpdater, project));
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (node != null) {
            return new Node[]{node};
        }
        return new Node[0];
    }

    protected void destroyNodes(Node[] node) {
        for (Node n : node) {
            Children children = n.getChildren();
            if (!(children instanceof HostKeyArray)) continue;
            ((HostKeyArray)children).dispose();
        }
        super.destroyNodes(node);
    }

    void ensureAddNotify() {
        if (this.myProjects == null) {
            this.addNotify();
        }
    }

    protected void addNotify() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesP: addNotify()");
        }
        this.resetProjects();
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        super.removeNotify();
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                this.myProjects.clear();
                this.resetKeys();
            }
            this.myProjects = null;
        }
    }

    private static final class ProjectComparator
    implements Comparator<Map.Entry<CsmProject, SortedName>> {
        private ProjectComparator() {
        }

        @Override
        public int compare(Map.Entry<CsmProject, SortedName> o1, Map.Entry<CsmProject, SortedName> o2) {
            if (o1.getKey().isArtificial() != o2.getKey().isArtificial()) {
                return o1.getKey().isArtificial() ? 1 : -1;
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

