/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hyperlinks;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class HyperlinkProviderImpl
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(Document doc, int offset) {
        if (!this.isPomFile(doc)) {
            return false;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence xml = th.tokenSequence(XMLTokenId.language());
        xml.move(offset);
        xml.moveNext();
        Token token = xml.token();
        if (token == null) {
            return false;
        }
        if (token.id() == XMLTokenId.TEXT) {
            String text;
            FileObject fo = this.getProjectDir(doc);
            if (this.getPath(fo, text = ((Object)token.text()).toString()) != null) {
                return true;
            }
            if (text != null && (text.startsWith("http://") || text.startsWith("https://"))) {
                return true;
            }
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (!this.isPomFile(doc)) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence xml = th.tokenSequence(XMLTokenId.language());
        xml.move(offset);
        xml.moveNext();
        Token token = xml.token();
        if (token == null) {
            return null;
        }
        if (token.id() == XMLTokenId.TEXT) {
            String text;
            FileObject fo = this.getProjectDir(doc);
            if (this.getPath(fo, text = ((Object)token.text()).toString()) != null) {
                return new int[]{xml.offset(), xml.offset() + text.length()};
            }
            if (text != null && (text.startsWith("http://") || text.startsWith("https://"))) {
                return new int[]{xml.offset(), xml.offset() + text.length()};
            }
        }
        return null;
    }

    public void performClickAction(Document doc, int offset) {
        if (!this.isPomFile(doc)) {
            return;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence xml = th.tokenSequence(XMLTokenId.language());
        xml.move(offset);
        xml.moveNext();
        Token token = xml.token();
        if (token == null) {
            return;
        }
        if (token.id() == XMLTokenId.TEXT) {
            String text;
            FileObject fo = this.getProjectDir(doc);
            if (this.getPath(fo, text = ((Object)token.text()).toString()) != null) {
                xml.movePrevious();
                token = xml.token();
                if (token != null && token.id() == XMLTokenId.TAG && token.text().equals(">")) {
                    xml.movePrevious();
                    token = xml.token();
                    if (token != null && token.id() == XMLTokenId.TAG && token.text().equals("<module")) {
                        text = text + "/pom.xml";
                    }
                }
                if (this.getPath(fo, text) != null) {
                    FileObject file = this.getPath(fo, text);
                    try {
                        DataObject dobj = DataObject.find((FileObject)file);
                        EditCookie edit = (EditCookie)dobj.getCookie(EditCookie.class);
                        if (edit != null) {
                            edit.edit();
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (text != null && (text.startsWith("http://") || text.startsWith("https://"))) {
                try {
                    URL url = new URL(text);
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private FileObject getProjectDir(Document doc) {
        DataObject dObject = NbEditorUtilities.getDataObject((Document)doc);
        return dObject.getPrimaryFile().getParent();
    }

    private FileObject getPath(FileObject parent, String path) {
        if (path.startsWith("${basedir}/")) {
            path = path.substring("${basedir}/".length());
        }
        while (path.startsWith("../") && parent.getParent() != null) {
            path = path.substring("../".length());
            parent = parent.getParent();
        }
        return parent.getFileObject(path);
    }

    private boolean isPomFile(Document doc) {
        DataObject dObject;
        String type = (String)doc.getProperty("mimeType");
        if (type != null) {
            if ("text/x-maven-pom+xml".equals(type)) {
                return true;
            }
            if (!"text/xml".equals(type)) {
                return false;
            }
        }
        if ((dObject = NbEditorUtilities.getDataObject((Document)doc)) != null && "pom.xml".equalsIgnoreCase(dObject.getPrimaryFile().getNameExt())) {
            return true;
        }
        return dObject != null && "settings.xml".equals(dObject.getPrimaryFile().getNameExt()) && ".m2".equals(dObject.getPrimaryFile().getParent().getNameExt());
    }
}

