/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.codegen.NewPluginPanel;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginContainer;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class PluginGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private PluginGenerator(POMModel pOMModel, JTextComponent jTextComponent) {
        this.model = pOMModel;
        this.component = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(PluginGenerator.class, (String)"NAME_Plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        NBVersionInfo nBVersionInfo;
        try {
            this.model.sync();
        }
        catch (IOException iOException) {
            Logger.getLogger(PluginGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", iOException);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PluginGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        FileObject fileObject = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (project != null);
        NewPluginPanel newPluginPanel = new NewPluginPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newPluginPanel, NbBundle.getMessage(PluginGenerator.class, (String)"TIT_Add_plugin"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION && (nBVersionInfo = newPluginPanel.getPlugin()) != null) {
            int n = -1;
            try {
                Configuration configuration;
                this.model.startTransaction();
                int n2 = this.component.getCaretPosition();
                PluginContainer pluginContainer = this.findContainer(n2, this.model);
                Plugin plugin = this.model.getFactory().createPlugin();
                plugin.setGroupId(nBVersionInfo.getGroupId());
                plugin.setArtifactId(nBVersionInfo.getArtifactId());
                plugin.setVersion(nBVersionInfo.getVersion());
                if (newPluginPanel.isConfiguration()) {
                    configuration = this.model.getFactory().createConfiguration();
                    configuration.setSimpleParameter("foo", "bar");
                    plugin.setConfiguration(configuration);
                }
                if (newPluginPanel.getGoals() != null && newPluginPanel.getGoals().size() > 0) {
                    configuration = this.model.getFactory().createExecution();
                    String string = null;
                    for (String string2 : newPluginPanel.getGoals()) {
                        configuration.addGoal(string2);
                        if (string != null) continue;
                        string = string2;
                    }
                    if (string != null) {
                        configuration.setId(string);
                    }
                    plugin.addExecution((PluginExecution)configuration);
                }
                pluginContainer.addPlugin(plugin);
                n = this.model.getAccess().findPosition((Node)plugin.getPeer());
            }
            finally {
                this.model.endTransaction();
            }
            if (n != -1) {
                this.component.setCaretPosition(n);
            }
        }
    }

    private PluginContainer findContainer(int n, POMModel pOMModel) {
        for (DocumentComponent documentComponent = pOMModel.findComponent(n); documentComponent != null; documentComponent = documentComponent.getParent()) {
            if (!(documentComponent instanceof PluginContainer)) continue;
            return (PluginContainer)documentComponent;
        }
        Build build = pOMModel.getProject().getBuild();
        if (build == null) {
            build = pOMModel.getFactory().createBuild();
            pOMModel.getProject().setBuild(build);
        }
        return build;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<PluginGenerator> arrayList = new ArrayList<PluginGenerator>();
            POMModel pOMModel = (POMModel)lookup.lookup(POMModel.class);
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            if (pOMModel != null) {
                arrayList.add(new PluginGenerator(pOMModel, jTextComponent));
            }
            return arrayList;
        }
    }
}

