# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Philippe Normand <philippe@fluendo.com>

from elisa.core.utils.i18n import install_translation
from elisa.core.utils import defer
from elisa.core.action import ContextualAction

from elisa.plugins.poblesec.plugins import PluginListViewMode, \
                                           InternetMediaController
from elisa.plugins.poblesec.base.list import GenericListViewMode
from elisa.plugins.poblesec.base.preview_list import \
    MenuItemPreviewListController
from elisa.plugins.poblesec.link import OpenLinkAction, LinksMenuViewMode


_ = install_translation('poblesec')


class PluginsMenuController(InternetMediaController):
    empty_label = _('No Plugin to configure')


class SettingsViewMode(GenericListViewMode):
    def get_label(self, item):
        if isinstance(item, ContextualAction):
            label = item.name
        else:
            label = item.label
        return defer.succeed(label)

    def get_default_image(self, item):
        return None

    def get_image(self, item, theme):
        return None

    def get_preview_image(self, item, theme):
        return None

class GenericSettingsController(MenuItemPreviewListController):
    """
    Generic controller meant to be reused by Plugins will to display
    an UI to configure their options.
    """
    view_mode = SettingsViewMode
    item_widget_kwargs = {'with_artwork_box': False}

    def create_actions(self):
        return OpenLinkAction(self), []

    def refresh(self):
        self.model[:] = self.model

    def item_activated(self, item):
        if isinstance(item, ContextualAction):
            return item.execute(None)
        return super(GenericSettingsController, self).item_activated(item)
