/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jruby.Ruby;
import org.jruby.RubyNil;
import org.jruby.embed.EmbedRubyInterfaceAdapter;
import org.jruby.embed.InvokeFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedRubyInterfaceAdapterImpl
implements EmbedRubyInterfaceAdapter {
    private ScriptingContainer container;

    public EmbedRubyInterfaceAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    @Override
    public <T> T getInstance(Object receiver2, Class<T> clazz) {
        Object o;
        if (clazz == null || !clazz.isInterface()) {
            return null;
        }
        Ruby runtime2 = this.container.getProvider().getRuntime();
        if (receiver2 == null || receiver2 instanceof RubyNil) {
            o = JavaEmbedUtils.rubyToJava(runtime2, runtime2.getTopSelf(), clazz);
        } else if (receiver2 instanceof IRubyObject) {
            o = JavaEmbedUtils.rubyToJava(runtime2, (IRubyObject)receiver2, clazz);
        } else {
            IRubyObject rubyReceiver = JavaUtil.convertJavaToRuby(runtime2, receiver2);
            o = JavaEmbedUtils.rubyToJava(runtime2, rubyReceiver, clazz);
        }
        String name2 = clazz.getName();
        try {
            Class<?> c = Class.forName(name2, true, o.getClass().getClassLoader());
            return (T)c.cast(o);
        }
        catch (ClassNotFoundException e) {
            Writer w = this.container.getErrorWriter();
            if (w instanceof PrintWriter) {
                e.printStackTrace((PrintWriter)w);
            } else {
                try {
                    w.write(e.getMessage());
                }
                catch (IOException ex) {
                    throw new InvokeFailedException(ex);
                }
            }
            throw new InvokeFailedException(e);
        }
    }
}

