/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import sun.invoke.empty.Empty;

class Invokers {
    private final MethodType targetType;
    private MethodHandle exactInvoker;
    private MethodHandle erasedInvoker;
    MethodHandle erasedInvokerWithDrops;
    private MethodHandle generalInvoker;
    private MethodHandle varargsInvoker;
    private final MethodHandle[] spreadInvokers;
    private MethodHandle uninitializedCallSite;
    private static MethodHandle THROW_UCS = null;

    Invokers(MethodType methodType) {
        this.targetType = methodType;
        this.spreadInvokers = new MethodHandle[methodType.parameterCount() + 1];
    }

    static MethodType invokerType(MethodType methodType) {
        return methodType.insertParameterTypes(0, MethodHandle.class);
    }

    MethodHandle exactInvoker() {
        MethodHandle methodHandle = this.exactInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        this.exactInvoker = methodHandle = this.lookupInvoker("invokeExact");
        return methodHandle;
    }

    MethodHandle generalInvoker() {
        MethodHandle methodHandle = this.generalInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        this.generalInvoker = methodHandle = this.lookupInvoker("invoke");
        return methodHandle;
    }

    private MethodHandle lookupInvoker(String string) {
        MethodHandle methodHandle;
        try {
            methodHandle = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, string, this.targetType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError("JVM cannot find invoker for " + this.targetType);
        }
        assert (Invokers.invokerType(this.targetType) == methodHandle.type());
        assert (!methodHandle.isVarargsCollector());
        return methodHandle;
    }

    MethodHandle erasedInvoker() {
        MethodHandle methodHandle = this.exactInvoker();
        MethodHandle methodHandle2 = this.erasedInvoker;
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        MethodType methodType = this.targetType.erase();
        this.erasedInvoker = methodHandle2 = methodHandle.asType(Invokers.invokerType(methodType));
        return methodHandle2;
    }

    MethodHandle spreadInvoker(int n) {
        MethodHandle methodHandle = this.spreadInvokers[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = this.generalInvoker();
        int n2 = this.targetType.parameterCount() - n;
        this.spreadInvokers[n] = methodHandle = methodHandle2.asSpreader(Object[].class, n2);
        return methodHandle;
    }

    MethodHandle varargsInvoker() {
        MethodHandle methodHandle = this.varargsInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        this.varargsInvoker = methodHandle = this.spreadInvoker(0).asType(Invokers.invokerType(MethodType.genericMethodType(0, true)));
        return methodHandle;
    }

    MethodHandle uninitializedCallSite() {
        MethodHandle methodHandle = this.uninitializedCallSite;
        if (methodHandle != null) {
            return methodHandle;
        }
        if (this.targetType.parameterCount() > 0) {
            MethodType methodType = this.targetType.dropParameterTypes(0, this.targetType.parameterCount());
            Invokers invokers = methodType.invokers();
            methodHandle = MethodHandles.dropArguments(invokers.uninitializedCallSite(), 0, this.targetType.parameterList());
            assert (methodHandle.type().equals((Object)this.targetType));
            this.uninitializedCallSite = methodHandle;
            return methodHandle;
        }
        if (THROW_UCS == null) {
            try {
                THROW_UCS = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Empty.class));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
        methodHandle = AdapterMethodHandle.makeRetypeRaw(this.targetType, THROW_UCS);
        assert (methodHandle.type().equals((Object)this.targetType));
        this.uninitializedCallSite = methodHandle;
        return methodHandle;
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }
}

