/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class AudioPlayer
extends Thread {
    private static AudioPlayer audioPlayer = null;
    private State state = State.INITIALIZING;
    private URL playingUrl = null;
    private double leadIn;
    private double calibration;
    private double position;
    private double bytesPerSecond;
    private static long chunk = 4000L;
    private double speed = 1.0;
    private Execute command = new Execute();

    public static void play(URL url) throws Exception {
        AudioPlayer.get().command.play(url, 0.0, 1.0);
    }

    public static void play(URL url, double seconds) throws Exception {
        AudioPlayer.get().command.play(url, seconds, 1.0);
    }

    public static void play(URL url, double seconds, double speed) throws Exception {
        AudioPlayer.get().command.play(url, seconds, speed);
    }

    public static void pause() throws Exception {
        AudioPlayer.get().command.pause();
    }

    public static URL url() {
        return AudioPlayer.get().playingUrl;
    }

    public static boolean paused() {
        return AudioPlayer.get().state == State.PAUSED;
    }

    public static boolean playing() {
        return AudioPlayer.get().state == State.PLAYING;
    }

    public static double position() {
        return AudioPlayer.get().position;
    }

    public static double speed() {
        return AudioPlayer.get().speed;
    }

    private static AudioPlayer get() {
        if (audioPlayer != null) {
            return audioPlayer;
        }
        try {
            audioPlayer = new AudioPlayer();
            return audioPlayer;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void reset() {
        if (audioPlayer != null) {
            try {
                AudioPlayer.pause();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AudioPlayer.audioPlayer.playingUrl = null;
        }
    }

    private AudioPlayer() {
        this.leadIn = Main.pref.getDouble("audio.leadin", "1.0");
        this.calibration = Main.pref.getDouble("audio.calibration", "1.0");
        this.start();
        while (this.state == State.INITIALIZING) {
            AudioPlayer.yield();
        }
    }

    public void run() {
        this.playingUrl = null;
        AudioInputStream audioInputStream = null;
        DataLine audioOutputLine = null;
        AudioFormat audioFormat = null;
        byte[] abData = new byte[(int)chunk];
        while (true) {
            try {
                while (true) {
                    switch (this.state) {
                        case INITIALIZING: {
                            this.state = State.NOTPLAYING;
                            break;
                        }
                        case NOTPLAYING: 
                        case PAUSED: {
                            AudioPlayer.sleep(200L);
                            break;
                        }
                        case PLAYING: {
                            this.command.possiblyInterrupt();
                            while (true) {
                                int nBytesRead = 0;
                                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                                this.position += (double)nBytesRead / this.bytesPerSecond;
                                this.command.possiblyInterrupt();
                                if (nBytesRead < 0) break;
                                audioOutputLine.write(abData, 0, nBytesRead);
                                this.command.possiblyInterrupt();
                            }
                            audioOutputLine.drain();
                            audioOutputLine.close();
                            audioOutputLine = null;
                            audioInputStream.close();
                            audioInputStream = null;
                            this.playingUrl = null;
                            this.state = State.NOTPLAYING;
                            this.command.possiblyInterrupt();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                AudioPlayer.interrupted();
                State stateChange = this.state;
                this.state = State.INTERRUPTED;
                try {
                    switch (this.command.command()) {
                        case PLAY: {
                            double offset = this.command.offset();
                            this.speed = this.command.speed();
                            if (this.playingUrl != this.command.url() || stateChange != State.PAUSED || offset != 0.0) {
                                if (audioInputStream != null) {
                                    audioInputStream.close();
                                    audioInputStream = null;
                                }
                                this.playingUrl = this.command.url();
                                audioInputStream = AudioSystem.getAudioInputStream(this.playingUrl);
                                audioFormat = audioInputStream.getFormat();
                                long nBytesRead = 0L;
                                this.position = 0.0;
                                double calibratedOffset = (offset -= this.leadIn) * this.calibration;
                                this.bytesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getFrameSize();
                                if (this.speed * this.bytesPerSecond > 256000.0) {
                                    this.speed = 256000.0 / this.bytesPerSecond;
                                }
                                if (calibratedOffset > 0.0) {
                                    long bytesToSkip;
                                    for (bytesToSkip = (long)(calibratedOffset * this.bytesPerSecond); bytesToSkip > chunk; bytesToSkip -= nBytesRead) {
                                        nBytesRead = audioInputStream.skip(chunk);
                                        if (nBytesRead > 0L) continue;
                                        throw new IOException(I18n.tr("This is after the end of the recording"));
                                    }
                                    if (bytesToSkip > 0L) {
                                        audioInputStream.skip(bytesToSkip);
                                    }
                                    this.position = offset;
                                }
                                if (audioOutputLine != null) {
                                    audioOutputLine.close();
                                }
                                audioFormat = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate() * (float)(this.speed * this.calibration), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate() * (float)(this.speed * this.calibration), audioFormat.isBigEndian());
                                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                                audioOutputLine = (SourceDataLine)AudioSystem.getLine(info);
                                audioOutputLine.open(audioFormat);
                                audioOutputLine.start();
                            }
                            stateChange = State.PLAYING;
                            break;
                        }
                        case PAUSE: {
                            stateChange = State.PAUSED;
                        }
                    }
                    this.command.ok(stateChange);
                }
                catch (Exception startPlayingException) {
                    this.command.failed(startPlayingException);
                }
                continue;
            }
            catch (Exception e) {
                this.state = State.NOTPLAYING;
                continue;
            }
            break;
        }
    }

    public static void audioMalfunction(Exception ex) {
        String msg = ex.getMessage();
        msg = msg == null ? I18n.tr("unspecified reason") : I18n.tr(msg);
        JOptionPane.showMessageDialog(Main.parent, "<html><p>" + msg + "</p></html>", I18n.tr("Error playing sound"), 0);
    }

    private class Execute {
        private Command command;
        private Result result;
        private Exception exception;
        private URL url;
        private double offset;
        private double speed;

        private Execute() {
        }

        protected void play(URL url, double offset, double speed) throws Exception {
            this.url = url;
            this.offset = offset;
            this.speed = speed;
            this.command = Command.PLAY;
            this.result = Result.WAITING;
            this.send();
        }

        protected void pause() throws Exception {
            this.command = Command.PAUSE;
            this.send();
        }

        private void send() throws Exception {
            this.result = Result.WAITING;
            AudioPlayer.this.interrupt();
            while (this.result == Result.WAITING) {
                Thread.sleep(10L);
            }
            if (this.result == Result.FAILED) {
                throw this.exception;
            }
        }

        private void possiblyInterrupt() throws InterruptedException {
            if (Thread.interrupted() || this.result == Result.WAITING) {
                throw new InterruptedException();
            }
        }

        protected void failed(Exception e) {
            this.exception = e;
            this.result = Result.FAILED;
            AudioPlayer.this.state = State.NOTPLAYING;
        }

        protected void ok(State newState) {
            this.result = Result.OK;
            AudioPlayer.this.state = newState;
        }

        protected double offset() {
            return this.offset;
        }

        protected double speed() {
            return this.speed;
        }

        protected URL url() {
            return this.url;
        }

        protected Command command() {
            return this.command;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Result {
        WAITING,
        OK,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        PLAY,
        PAUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIALIZING,
        NOTPLAYING,
        PLAYING,
        PAUSED,
        INTERRUPTED;

    }
}

