/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerObjectReader
extends OsmServerReader {
    private PrimitiveId id;
    private boolean full;

    public OsmServerObjectReader(long id, OsmPrimitiveType type, boolean full) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value > 0 for parameter ''{0}'', got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.id = new SimplePrimitiveId(id, type);
        this.full = full;
    }

    public OsmServerObjectReader(PrimitiveId id, boolean full) {
        CheckParameterUtil.ensureValidPrimitiveId(id, "id");
        this.id = id;
        this.full = full;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask("", 1);
        InputStream in = null;
        try {
            DataSet data;
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.id.getType().getAPIName());
            sb.append("/");
            sb.append(this.id.getUniqueId());
            if (this.full && !this.id.getType().equals((Object)OsmPrimitiveType.NODE)) {
                sb.append("/full");
            }
            if ((in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true))) == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet e = data = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(-1, false));
            return e;
        }
        catch (OsmTransferException e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            this.activeConnection = null;
        }
    }
}

