/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.ApiUrlTestTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsmApiUrlInputPanel
extends JPanel {
    public static final String API_URL_PROP = OsmApiUrlInputPanel.class.getName() + ".apiUrl";
    private static final String defaulturl = "http://api.openstreetmap.org/api";
    private JLabel lblValid;
    private JLabel lblApiUrl;
    private JTextField tfOsmServerUrl;
    private ApiUrlValidator valOsmServerUrl;
    private SideButton btnTest;
    private JCheckBox cbUseDefaultServerUrl;

    protected JPanel buildDefultServerUrlPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        gc.gridwidth = 1;
        this.cbUseDefaultServerUrl = new JCheckBox();
        pnl.add((Component)this.cbUseDefaultServerUrl, gc);
        this.cbUseDefaultServerUrl.addItemListener(new UseDefaultServerUrlChangeHandler());
        gc.gridx = 1;
        gc.weightx = 1.0;
        JLabel lbl = new JLabel(I18n.tr("<html>Use the default OSM server URL (<strong>{0}</strong>)</html>", defaulturl));
        lbl.setFont(lbl.getFont().deriveFont(0));
        pnl.add((Component)lbl, gc);
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridwidth = 4;
        this.add((Component)this.buildDefultServerUrlPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        this.lblApiUrl = new JLabel(I18n.tr("OSM Server URL:"));
        this.add((Component)this.lblApiUrl, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfOsmServerUrl = new JTextField();
        this.add((Component)this.tfOsmServerUrl, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmServerUrl);
        this.valOsmServerUrl = new ApiUrlValidator(this.tfOsmServerUrl);
        this.valOsmServerUrl.validate();
        ApiUrlPropagator propagator = new ApiUrlPropagator();
        this.tfOsmServerUrl.addActionListener(propagator);
        this.tfOsmServerUrl.addFocusListener(propagator);
        gc.gridx = 2;
        gc.weightx = 0.0;
        this.lblValid = new JLabel();
        this.add((Component)this.lblValid, gc);
        gc.gridx = 3;
        gc.weightx = 0.0;
        ValidateApiUrlAction actTest = new ValidateApiUrlAction();
        this.tfOsmServerUrl.getDocument().addDocumentListener(actTest);
        this.btnTest = new SideButton(actTest);
        this.add((Component)this.btnTest, gc);
    }

    public OsmApiUrlInputPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ApiUrl"));
    }

    public void initFromPreferences() {
        String url = Main.pref.get("osm-server.url", null);
        if (url == null) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.firePropertyChange(API_URL_PROP, null, defaulturl);
        } else if (url.trim().equals(defaulturl)) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.firePropertyChange(API_URL_PROP, null, defaulturl);
        } else {
            this.cbUseDefaultServerUrl.setSelected(false);
            this.tfOsmServerUrl.setText(url);
            this.firePropertyChange(API_URL_PROP, null, url);
        }
    }

    public void saveToPreferences() {
        if (this.cbUseDefaultServerUrl.isSelected()) {
            Main.pref.put("osm-server.url", null);
        } else if (this.tfOsmServerUrl.getText().trim().equals(defaulturl)) {
            Main.pref.put("osm-server.url", null);
        } else {
            Main.pref.put("osm-server.url", this.tfOsmServerUrl.getText().trim());
        }
    }

    public void setApiUrlInputEnabled(boolean enabled) {
        this.lblApiUrl.setEnabled(enabled);
        this.tfOsmServerUrl.setEnabled(enabled);
        this.lblValid.setEnabled(enabled);
        this.btnTest.setEnabled(enabled);
    }

    class ApiUrlPropagator
    extends FocusAdapter
    implements ActionListener {
        ApiUrlPropagator() {
        }

        public void propagate() {
            OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, OsmApiUrlInputPanel.this.tfOsmServerUrl.getText());
        }

        public void actionPerformed(ActionEvent e) {
            this.propagate();
        }

        public void focusLost(FocusEvent arg0) {
            this.propagate();
        }
    }

    class UseDefaultServerUrlChangeHandler
    implements ItemListener {
        UseDefaultServerUrlChangeHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(false);
                    OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, OsmApiUrlInputPanel.defaulturl);
                    break;
                }
                case 2: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(true);
                    OsmApiUrlInputPanel.this.valOsmServerUrl.validate();
                    OsmApiUrlInputPanel.this.tfOsmServerUrl.requestFocusInWindow();
                    OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, OsmApiUrlInputPanel.this.tfOsmServerUrl.getText());
                }
            }
        }
    }

    private static class ApiUrlValidator
    extends AbstractTextComponentValidator {
        public ApiUrlValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        public boolean isValid() {
            if (this.getComponent().getText().trim().equals("")) {
                return false;
            }
            try {
                new URL(this.getComponent().getText().trim());
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        public void validate() {
            if (this.getComponent().getText().trim().equals("")) {
                this.feedbackInvalid(I18n.tr("OSM API URL must not be empty. Please enter the OSM API URL."));
                return;
            }
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid URL"));
            } else {
                this.feedbackValid(I18n.tr("Please enter the OSM API URL."));
            }
        }
    }

    class ValidateApiUrlAction
    extends AbstractAction
    implements DocumentListener {
        private String lastTestedUrl = null;

        public ValidateApiUrlAction() {
            this.putValue("Name", I18n.tr("Validate"));
            this.putValue("ShortDescription", I18n.tr("Test the API URL"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent arg0) {
            final String url = OsmApiUrlInputPanel.this.tfOsmServerUrl.getText().trim();
            final ApiUrlTestTask task = new ApiUrlTestTask(OsmApiUrlInputPanel.this, url);
            Main.worker.submit(task);
            Runnable r = new Runnable(){

                public void run() {
                    if (task.isCanceled()) {
                        return;
                    }
                    Runnable r = new Runnable(){

                        public void run() {
                            if (task.isSuccess()) {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("dialogs/changeset", "valid"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("The API URL is valid."));
                                ValidateApiUrlAction.this.lastTestedUrl = url;
                                ValidateApiUrlAction.this.updateEnabledState();
                            } else {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("Validation failed. The API URL seems to be invalid."));
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
            };
            Main.worker.submit(r);
        }

        protected void updateEnabledState() {
            boolean enabled;
            boolean bl = enabled = !OsmApiUrlInputPanel.this.tfOsmServerUrl.getText().trim().equals("") && !OsmApiUrlInputPanel.this.tfOsmServerUrl.getText().trim().equals(this.lastTestedUrl);
            if (enabled) {
                OsmApiUrlInputPanel.this.lblValid.setIcon(null);
            }
            this.setEnabled(enabled);
        }

        public void changedUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }
    }
}

