/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSettingsPanel
extends JPanel
implements TableModelListener {
    private TagEditorPanel pnlTagEditor;
    private ChangesetCommentModel changesetCommentModel;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.pnlTagEditor = new TagEditorPanel(null);
        this.add((Component)this.pnlTagEditor, "Center");
    }

    public TagSettingsPanel(ChangesetCommentModel changesetCommentModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetCommentModel.addObserver(new ChangesetCommentObserver());
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected String getDefaultCreatedBy() {
        Object ua = System.getProperties().get("http.agent");
        return ua == null ? "JOSM" : ua.toString();
    }

    protected void setUploadComment(String comment) {
        String commentInTag;
        if (comment == null) {
            comment = "";
        }
        if ((comment = comment.trim()).equals(commentInTag = this.getUploadComment())) {
            return;
        }
        if (comment.equals("")) {
            this.pnlTagEditor.getModel().delete("comment");
            return;
        }
        TagModel tag = this.pnlTagEditor.getModel().get("comment");
        if (tag == null) {
            tag = new TagModel("comment", comment);
            this.pnlTagEditor.getModel().add(tag);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tag, comment);
        }
    }

    protected String getUploadComment() {
        TagModel tag = this.pnlTagEditor.getModel().get("comment");
        if (tag == null) {
            return null;
        }
        return tag.getValue();
    }

    protected void initNewChangeset() {
        String currentComment = this.getUploadComment();
        this.pnlTagEditor.getModel().clear();
        if (currentComment != null) {
            this.pnlTagEditor.getModel().add("comment", currentComment);
        }
        this.pnlTagEditor.getModel().add("created_by", this.getDefaultCreatedBy());
    }

    protected void initFromExistingChangeset(Changeset cs) {
        String currentComment = this.getUploadComment();
        Map<String, String> tags = cs.getKeys();
        if (tags.get("comment") == null) {
            tags.put("comment", currentComment);
        }
        tags.put("created_by", this.getDefaultCreatedBy());
        this.pnlTagEditor.getModel().initFromTags(tags);
    }

    public void initFromChangeset(Changeset cs) {
        if (cs == null) {
            this.initNewChangeset();
        } else {
            this.initFromExistingChangeset(cs);
        }
    }

    public Map<String, String> getTags() {
        return this.pnlTagEditor.getModel().getTags();
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(Main.main.getEditLayer());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        String uploadComment = this.getUploadComment();
        this.changesetCommentModel.setComment(uploadComment);
    }

    class ChangesetCommentObserver
    implements Observer {
        ChangesetCommentObserver() {
        }

        public void update(Observable o, Object arg) {
            if (!(o instanceof ChangesetCommentModel)) {
                return;
            }
            String newValue = (String)arg;
            String oldValue = TagSettingsPanel.this.getUploadComment();
            if (oldValue == null) {
                oldValue = "";
            }
            if (!oldValue.equals(newValue)) {
                TagSettingsPanel.this.setUploadComment((String)arg);
            }
        }
    }
}

