/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScrollViewport
extends JPanel {
    private static final int NO_SCROLL = 0;
    public static final int UP_DIRECTION = 1;
    public static final int DOWN_DIRECTION = 2;
    public static final int LEFT_DIRECTION = 4;
    public static final int RIGHT_DIRECTION = 8;
    public static final int VERTICAL_DIRECTION = 3;
    public static final int HORIZONTAL_DIRECTION = 12;
    public static final int ALL_DIRECTION = 15;
    private JViewport vp = new JViewport();
    private JComponent component = null;
    private List<JButton> buttons = new ArrayList<JButton>();
    private Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            ScrollViewport.this.scroll();
        }
    });
    private int scrollDirection = 0;

    public ScrollViewport(JComponent c, int direction) {
        this(direction);
        this.add(c);
    }

    public ScrollViewport(int direction) {
        JButton button;
        this.setLayout(new BorderLayout());
        if ((direction & 1) > 0) {
            button = new JButton();
            button.addMouseListener(new ScrollViewPortMouseListener(1));
            button.setPreferredSize(new Dimension(10, 10));
            button.setIcon(ImageProvider.get("svpUp"));
            this.add((Component)button, "North");
            this.buttons.add(button);
        }
        if ((direction & 2) > 0) {
            button = new JButton();
            button.addMouseListener(new ScrollViewPortMouseListener(2));
            button.setPreferredSize(new Dimension(10, 10));
            button.setIcon(ImageProvider.get("svpDown"));
            this.add((Component)button, "South");
            this.buttons.add(button);
        }
        if ((direction & 4) > 0) {
            button = new JButton();
            button.addMouseListener(new ScrollViewPortMouseListener(4));
            button.setPreferredSize(new Dimension(10, 10));
            button.setIcon(ImageProvider.get("svpLeft"));
            this.add((Component)button, "West");
            this.buttons.add(button);
        }
        if ((direction & 8) > 0) {
            button = new JButton();
            button.addMouseListener(new ScrollViewPortMouseListener(8));
            button.setPreferredSize(new Dimension(10, 10));
            button.setIcon(ImageProvider.get("svpRight"));
            this.add((Component)button, "East");
            this.buttons.add(button);
        }
        this.add((Component)this.vp, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ScrollViewport.this.showOrHideButtons();
            }
        });
        this.showOrHideButtons();
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(400);
    }

    public synchronized void scroll() {
        int direction = this.scrollDirection;
        if (this.component == null || direction == 0) {
            return;
        }
        Rectangle viewRect = this.vp.getViewRect();
        int deltaX = 0;
        int deltaY = 0;
        if (direction < 4) {
            deltaY = viewRect.height * 2 / 7;
        } else {
            deltaX = viewRect.width * 2 / 7;
        }
        switch (direction) {
            case 1: {
                deltaY *= -1;
                break;
            }
            case 4: {
                deltaX *= -1;
            }
        }
        this.scroll(deltaX, deltaY);
    }

    public synchronized void scroll(int deltaX, int deltaY) {
        if (this.component == null) {
            return;
        }
        Dimension compSize = this.component.getSize();
        Rectangle viewRect = this.vp.getViewRect();
        int newX = viewRect.x + deltaX;
        int newY = viewRect.y + deltaY;
        if (newY < 0) {
            newY = 0;
        }
        if (newY > compSize.height - viewRect.height) {
            newY = compSize.height - viewRect.height;
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newX > compSize.width - viewRect.width) {
            newX = compSize.width - viewRect.width;
        }
        this.vp.setViewPosition(new Point(newX, newY));
    }

    public void showOrHideButtons() {
        boolean needButtons = this.vp.getViewSize().height > this.vp.getViewRect().height || this.vp.getViewSize().width > this.vp.getViewRect().width;
        for (JButton b : this.buttons) {
            b.setVisible(needButtons);
        }
    }

    public Rectangle getViewRect() {
        return this.vp.getViewRect();
    }

    public Dimension getViewSize() {
        return this.vp.getViewSize();
    }

    public Point getViewPosition() {
        return this.vp.getViewPosition();
    }

    public void add(JComponent c) {
        this.vp.removeAll();
        this.component = c;
        this.vp.add(c);
    }

    private class ScrollViewPortMouseListener
    extends MouseAdapter {
        private int direction;

        public ScrollViewPortMouseListener(int direction) {
            this.direction = direction;
        }

        public void mouseExited(MouseEvent arg0) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        public void mouseReleased(MouseEvent arg0) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        public void mousePressed(MouseEvent arg0) {
            ScrollViewport.this.scrollDirection = this.direction;
            ScrollViewport.this.scroll();
            ScrollViewport.this.timer.restart();
        }
    }
}

