/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class UndoRedoHandler
implements MapView.LayerChangeListener {
    public final LinkedList<Command> commands = new LinkedList();
    public final LinkedList<Command> redoCommands = new LinkedList();
    public final LinkedList<OsmDataLayer.CommandQueueListener> listenerCommands = new LinkedList();

    public UndoRedoHandler() {
        MapView.addLayerChangeListener(this);
    }

    public void addNoRedraw(Command c) {
        c.executeCommand();
        this.commands.add(c);
        if (this.commands.size() > Main.pref.getInteger("undo.max", 1000)) {
            this.commands.removeFirst();
        }
        this.redoCommands.clear();
    }

    public void afterAdd() {
        this.fireCommandsChanged();
        Main.main.getCurrentDataSet().fireSelectionChanged();
    }

    public synchronized void add(Command c) {
        this.addNoRedraw(c);
        this.afterAdd();
    }

    public void undo() {
        this.undo(1);
    }

    public synchronized void undo(int num) {
        if (this.commands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> oldSelection = Main.main.getCurrentDataSet().getSelected();
        for (int i = 1; i <= num; ++i) {
            Command c = this.commands.removeLast();
            c.undoCommand();
            this.redoCommands.addFirst(c);
            if (this.commands.isEmpty()) break;
        }
        this.fireCommandsChanged();
        Collection<OsmPrimitive> newSelection = Main.main.getCurrentDataSet().getSelected();
        if (!((Object)oldSelection).equals(newSelection)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void redo() {
        this.redo(1);
    }

    public void redo(int num) {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> oldSelection = Main.main.getCurrentDataSet().getSelected();
        for (int i = 0; i < num; ++i) {
            Command c = this.redoCommands.removeFirst();
            c.executeCommand();
            this.commands.add(c);
            if (this.redoCommands.isEmpty()) break;
        }
        this.fireCommandsChanged();
        Collection<OsmPrimitive> newSelection = Main.main.getCurrentDataSet().getSelected();
        if (!((Object)oldSelection).equals(newSelection)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void fireCommandsChanged() {
        for (OsmDataLayer.CommandQueueListener l : this.listenerCommands) {
            l.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void clean(Layer layer) {
        if (layer == null) {
            return;
        }
        boolean changed = false;
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            if (!((Command)it.next()).invalidBecauselayerRemoved(layer)) continue;
            it.remove();
            changed = true;
        }
        it = this.redoCommands.iterator();
        while (it.hasNext()) {
            if (!((Command)it.next()).invalidBecauselayerRemoved(layer)) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            this.fireCommandsChanged();
        }
    }

    public void layerRemoved(Layer oldLayer) {
        this.clean(oldLayer);
    }

    public void layerAdded(Layer newLayer) {
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }
}

