/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutosaveTask
extends TimerTask
implements MapView.LayerChangeListener,
DataSetListenerAdapter.Listener {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final String AUTOSAVE_DIR = "autosave";
    private static final String DELETED_LAYERS_DIR = "autosave/deleted_layers";
    public static final BooleanProperty PROP_AUTOSAVE_ENABLED = new BooleanProperty("autosave.enabled", true);
    public static final IntegerProperty PROP_FILES_PER_LAYER = new IntegerProperty("autosave.filesPerLayer", 1);
    public static final IntegerProperty PROP_DELETED_LAYERS = new IntegerProperty("autosave.deletedLayersBackupCount", 5);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("autosave.interval", 300);
    public static final IntegerProperty PROP_INDEX_LIMIT = new IntegerProperty("autosave.index-limit", 1000);
    private final DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter(this);
    private Set<DataSet> changedDatasets = new HashSet<DataSet>();
    private final List<AutosaveLayerInfo> layersInfo = new ArrayList<AutosaveLayerInfo>();
    private Timer timer;
    private final Object layersLock = new Object();
    private final Deque<File> deletedLayers = new LinkedList<File>();
    private final File autosaveDir = new File(Main.pref.getPreferencesDir() + "autosave");
    private final File deletedLayersDir = new File(Main.pref.getPreferencesDir() + "autosave/deleted_layers");

    public void schedule() {
        if (PROP_INTERVAL.get() > 0) {
            if (!this.autosaveDir.exists() && !this.autosaveDir.mkdirs()) {
                System.out.println(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.autosaveDir.getAbsolutePath()));
                return;
            }
            if (!this.deletedLayersDir.exists() && !this.deletedLayersDir.mkdirs()) {
                System.out.println(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.deletedLayersDir.getAbsolutePath()));
                return;
            }
            for (File f : this.deletedLayersDir.listFiles()) {
                this.deletedLayers.add(f);
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 1000L, (long)(PROP_INTERVAL.get() * 1000));
            MapView.addLayerChangeListener(this);
            if (Main.isDisplayingMapView()) {
                for (OsmDataLayer l : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
                    this.registerNewlayer(l);
                }
            }
        }
    }

    private String getFileName(String layerName, int index) {
        String result = layerName;
        for (int i = 0; i < ILLEGAL_CHARACTERS.length; ++i) {
            result = result.replaceAll(Pattern.quote(String.valueOf(ILLEGAL_CHARACTERS[i])), '&' + String.valueOf((int)ILLEGAL_CHARACTERS[i]) + ';');
        }
        if (index != 0) {
            result = result + '_' + index;
        }
        return result;
    }

    private void setLayerFileName(AutosaveLayerInfo layer) {
        int index = 0;
        while (true) {
            String filename = this.getFileName(layer.layer.getName(), index);
            boolean foundTheSame = false;
            for (AutosaveLayerInfo info : this.layersInfo) {
                if (info == layer || !filename.equals(info.layerFileName)) continue;
                foundTheSame = true;
                break;
            }
            if (!foundTheSame) {
                layer.layerFileName = filename;
                return;
            }
            ++index;
        }
    }

    private File getNewLayerFile(AutosaveLayerInfo layer) {
        int index = 0;
        Date now = new Date();
        while (true) {
            File result = new File(this.autosaveDir, String.format("%1$s_%2$tY%2$tm%2$td_%2$tH%2$tM%3$s.osm", layer.layerFileName, now, index == 0 ? "" : "_" + index));
            try {
                if (result.createNewFile()) {
                    return result;
                }
                System.out.println(I18n.tr("Unable to create file {0}, other filename will be used", result.getAbsolutePath()));
                if (index > PROP_INDEX_LIMIT.get()) {
                    throw new IOException("index limit exceeded");
                }
            }
            catch (IOException e) {
                System.err.println(I18n.tr("IOError while creating file, autosave will be skipped: {0}", e.getMessage()));
                return null;
            }
            ++index;
        }
    }

    private void savelayer(AutosaveLayerInfo info) throws IOException {
        File file;
        if (!info.layer.getName().equals(info.layerName)) {
            this.setLayerFileName(info);
            info.layerName = info.layer.getName();
        }
        if (this.changedDatasets.contains(info.layer.data) && (file = this.getNewLayerFile(info)) != null) {
            info.backupFiles.add(file);
            new OsmExporter().exportData(file, info.layer);
        }
        while (info.backupFiles.size() > PROP_FILES_PER_LAYER.get()) {
            File oldFile = info.backupFiles.remove();
            if (oldFile.delete()) continue;
            System.out.println(I18n.tr("Unable to delete old backup file {0}", oldFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.layersLock;
        synchronized (object) {
            try {
                for (AutosaveLayerInfo info : this.layersInfo) {
                    this.savelayer(info);
                }
                this.changedDatasets.clear();
            }
            catch (Throwable t) {
                System.err.println("Autosave failed: ");
                t.printStackTrace();
            }
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewlayer(OsmDataLayer layer) {
        Object object = this.layersLock;
        synchronized (object) {
            layer.data.addDataSetListener(this.datasetAdapter);
            AutosaveLayerInfo info = new AutosaveLayerInfo();
            info.layer = layer;
            this.layersInfo.add(info);
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.registerNewlayer((OsmDataLayer)newLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof OsmDataLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                OsmDataLayer osmLayer = (OsmDataLayer)oldLayer;
                osmLayer.data.removeDataSetListener(this.datasetAdapter);
                Iterator<AutosaveLayerInfo> it = this.layersInfo.iterator();
                while (it.hasNext()) {
                    AutosaveLayerInfo info = it.next();
                    if (info.layer != osmLayer) continue;
                    try {
                        this.savelayer(info);
                        File lastFile = info.backupFiles.pollLast();
                        if (lastFile != null) {
                            this.moveToDeletedLayersFolder(lastFile);
                        }
                        for (File file : info.backupFiles) {
                            file.delete();
                        }
                    }
                    catch (IOException e) {
                        System.err.println(I18n.tr("Error while creating backup of removed layer: {0}", e.getMessage()));
                    }
                    it.remove();
                }
            }
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.changedDatasets.add(event.getDataset());
    }

    public List<File> getUnsavedLayersFiles() {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = this.autosaveDir.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            result.add(file);
        }
        return result;
    }

    public List<OsmDataLayer> getUnsavedLayers() {
        ArrayList<OsmDataLayer> result = new ArrayList<OsmDataLayer>();
        for (File f : this.getUnsavedLayersFiles()) {
            try {
                DataSet ds = OsmReader.parseDataSet(new FileInputStream(f), NullProgressMonitor.INSTANCE);
                String layerName = f.getName();
                layerName = layerName.substring(0, layerName.lastIndexOf(46));
                result.add(new OsmDataLayer(ds, layerName, null));
                this.moveToDeletedLayersFolder(f);
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + f.getAbsolutePath() + " not found");
            }
            catch (IllegalDataException e) {
                System.err.println(I18n.tr("Unable to read autosaved osm data ({0}) - {1}", f.getAbsoluteFile(), e.getMessage()));
            }
        }
        return result;
    }

    private void moveToDeletedLayersFolder(File f) {
        File backupFile = new File(this.deletedLayersDir, f.getName());
        if (backupFile.exists()) {
            this.deletedLayers.remove(backupFile);
            backupFile.delete();
        }
        if (f.renameTo(backupFile)) {
            this.deletedLayers.add(backupFile);
        } else {
            System.err.println(String.format("Warning: Could not move autosaved file %s to %s folder", f.getName(), this.deletedLayersDir.getName()));
            f.delete();
        }
        while (this.deletedLayers.size() > PROP_DELETED_LAYERS.get()) {
            this.deletedLayers.remove().delete();
        }
    }

    public void dicardUnsavedLayers() {
        for (File f : this.getUnsavedLayersFiles()) {
            this.moveToDeletedLayersFolder(f);
        }
    }

    private static class AutosaveLayerInfo {
        OsmDataLayer layer;
        String layerName;
        String layerFileName;
        final Deque<File> backupFiles = new LinkedList<File>();

        private AutosaveLayerInfo() {
        }
    }
}

