/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AddNodeAction
extends JosmAction {
    public AddNodeAction() {
        super(I18n.tr("Add Node..."), "addnode", I18n.tr("Add a node by entering latitude and longitude."), Shortcut.registerShortcut("addnode", I18n.tr("Edit: {0}", I18n.tr("Add Node...")), 68, 3, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/AddNode"));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LatLonDialog dialog = new LatLonDialog(Main.parent, I18n.tr("Add Node..."), HelpUtil.ht("/Action/AddNode"));
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        LatLon coordinates = dialog.getCoordinates();
        if (coordinates == null) {
            return;
        }
        Node nnew = new Node(coordinates);
        Main.main.undoRedo.add(new AddCommand(nnew));
        this.getCurrentDataSet().setSelected(nnew);
        Main.map.mapView.repaint();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }
}

