/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.crypto.EType;

public final class KrbAsReqBuilder {
    private KDCOptions options;
    private PrincipalName cname;
    private PrincipalName sname;
    private KerberosTime from;
    private KerberosTime till;
    private KerberosTime rtime;
    private HostAddresses addresses;
    private final char[] password;
    private final KeyTab ktab;
    private PAData[] paList;
    private KrbAsReq req;
    private KrbAsRep rep;
    private State state;

    private void init(PrincipalName principalName) throws KrbException {
        if (principalName.getRealm() == null) {
            principalName.setRealm(Config.getInstance().getDefaultRealm());
        }
        this.cname = principalName;
        this.state = State.INIT;
    }

    public KrbAsReqBuilder(PrincipalName principalName, KeyTab keyTab) throws KrbException {
        this.init(principalName);
        this.ktab = keyTab;
        this.password = null;
    }

    public KrbAsReqBuilder(PrincipalName principalName, char[] cArray) throws KrbException {
        this.init(principalName);
        this.password = (char[])cArray.clone();
        this.ktab = null;
    }

    public EncryptionKey[] getKeys() throws KrbException {
        this.checkState(State.REQ_OK, "Cannot get keys");
        if (this.password != null) {
            int[] nArray = EType.getDefaults("default_tkt_enctypes");
            EncryptionKey[] encryptionKeyArray = new EncryptionKey[nArray.length];
            String string = null;
            try {
                int n;
                for (n = 0; n < nArray.length; ++n) {
                    PAData.SaltAndParams saltAndParams = PAData.getSaltAndParams(nArray[n], this.paList);
                    if (saltAndParams == null) continue;
                    if (nArray[n] != 23 && saltAndParams.salt != null) {
                        string = saltAndParams.salt;
                    }
                    encryptionKeyArray[n] = EncryptionKey.acquireSecretKey(this.cname, this.password, nArray[n], saltAndParams);
                }
                if (string == null) {
                    string = this.cname.getSalt();
                }
                for (n = 0; n < nArray.length; ++n) {
                    if (encryptionKeyArray[n] != null) continue;
                    encryptionKeyArray[n] = EncryptionKey.acquireSecretKey(this.password, string, nArray[n], null);
                }
            }
            catch (IOException iOException) {
                KrbException krbException = new KrbException(909);
                krbException.initCause(iOException);
                throw krbException;
            }
            return encryptionKeyArray;
        }
        throw new IllegalStateException("Required password not provided");
    }

    public void setOptions(KDCOptions kDCOptions) {
        this.checkState(State.INIT, "Cannot specify options");
        this.options = kDCOptions;
    }

    public void setTarget(PrincipalName principalName) {
        this.checkState(State.INIT, "Cannot specify target");
        this.sname = principalName;
    }

    public void setAddresses(HostAddresses hostAddresses) {
        this.checkState(State.INIT, "Cannot specify addresses");
        this.addresses = hostAddresses;
    }

    private KrbAsReq build(EncryptionKey encryptionKey) throws KrbException, IOException {
        int[] nArray;
        if (this.password != null) {
            nArray = EType.getDefaults("default_tkt_enctypes");
        } else {
            EncryptionKey[] encryptionKeyArray = Krb5Util.keysFromJavaxKeyTab(this.ktab, this.cname);
            nArray = EType.getDefaults("default_tkt_enctypes", encryptionKeyArray);
            for (EncryptionKey encryptionKey2 : encryptionKeyArray) {
                encryptionKey2.destroy();
            }
        }
        return new KrbAsReq(encryptionKey, this.options, this.cname, this.sname, this.from, this.till, this.rtime, nArray, this.addresses);
    }

    private KrbAsReqBuilder resolve() throws KrbException, Asn1Exception, IOException {
        if (this.ktab != null) {
            this.rep.decryptUsingKeyTab(this.ktab, this.req, this.cname);
        } else {
            this.rep.decryptUsingPassword(this.password, this.req, this.cname);
        }
        if (this.rep.getPA() != null) {
            if (this.paList == null || this.paList.length == 0) {
                this.paList = this.rep.getPA();
            } else {
                int n = this.rep.getPA().length;
                if (n > 0) {
                    int n2 = this.paList.length;
                    this.paList = Arrays.copyOf(this.paList, this.paList.length + n);
                    System.arraycopy(this.rep.getPA(), 0, this.paList, n2, n);
                }
            }
        }
        return this;
    }

    private KrbAsReqBuilder send() throws KrbException, IOException {
        boolean bl = false;
        KdcComm kdcComm = new KdcComm(this.cname.getRealmAsString());
        EncryptionKey encryptionKey = null;
        while (true) {
            try {
                this.req = this.build(encryptionKey);
                this.rep = new KrbAsRep(kdcComm.send(this.req.encoding()));
                return this;
            }
            catch (KrbException krbException) {
                if (!(bl || krbException.returnCode() != 24 && krbException.returnCode() != 25)) {
                    if (Krb5.DEBUG) {
                        System.out.println("KrbAsReqBuilder: PREAUTH FAILED/REQ, re-send AS-REQ");
                    }
                    bl = true;
                    KRBError kRBError = krbException.getError();
                    int n = PAData.getPreferredEType(kRBError.getPA(), EType.getDefaults("default_tkt_enctypes")[0]);
                    if (this.password == null) {
                        EncryptionKey[] encryptionKeyArray = Krb5Util.keysFromJavaxKeyTab(this.ktab, this.cname);
                        encryptionKey = EncryptionKey.findKey(n, encryptionKeyArray);
                        if (encryptionKey != null) {
                            encryptionKey = (EncryptionKey)encryptionKey.clone();
                        }
                        for (EncryptionKey encryptionKey2 : encryptionKeyArray) {
                            encryptionKey2.destroy();
                        }
                    } else {
                        encryptionKey = EncryptionKey.acquireSecretKey(this.cname, this.password, n, PAData.getSaltAndParams(n, kRBError.getPA()));
                    }
                    this.paList = kRBError.getPA();
                    continue;
                }
                throw krbException;
            }
            break;
        }
    }

    public KrbAsReqBuilder action() throws KrbException, Asn1Exception, IOException {
        this.checkState(State.INIT, "Cannot call action");
        this.state = State.REQ_OK;
        return this.send().resolve();
    }

    public Credentials getCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve creds");
        return this.rep.getCreds();
    }

    public sun.security.krb5.internal.ccache.Credentials getCCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve CCreds");
        return this.rep.getCCreds();
    }

    public void destroy() {
        this.state = State.DESTROYED;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }

    private void checkState(State state, String string) {
        if (this.state != state) {
            throw new IllegalStateException(string + " at " + (Object)((Object)state) + " state");
        }
    }

    private static enum State {
        INIT,
        REQ_OK,
        DESTROYED;

    }
}

