/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.SplitterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesSplitter
extends BaseSplitter {
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\p{L}*");

    @Override
    public List<CheckArea> split(@Nullable String text, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/PropertiesSplitter.split must not be null");
        }
        if (text == null || StringUtil.isEmpty((String)text)) {
            return null;
        }
        ArrayList<CheckArea> results = new ArrayList<CheckArea>();
        IdentifierSplitter splitter = SplitterFactory.getInstance().getIdentifierSplitter();
        Matcher matcher = WORD.matcher(text.substring(range.getStartOffset(), range.getEndOffset()));
        while (matcher.find()) {
            TextRange found;
            List<CheckArea> res;
            if (matcher.end() - matcher.start() < 3 || (res = splitter.split(text, found = PropertiesSplitter.matcherRange(range, matcher))) == null) continue;
            results.addAll(res);
        }
        return results.size() == 0 ? null : results;
    }
}

