/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit.segments;

import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.PacketWriter;
import com.intellij.rt.execution.junit.segments.TraceFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import junit.runner.BaseTestRunner;

public class Packet
extends PacketWriter {
    private final OutputObjectRegistry myRegistry;
    private final PacketProcessor myTransport;
    public static final char ourSpecialSymbol = '$';
    public static final char[] ourSymbolsToEncode = new char[]{'\n', '\r', '/'};
    public static final int CODE_LENGTH = 2;

    public Packet(PacketProcessor transport, OutputObjectRegistry registry) {
        this.myTransport = transport;
        this.myRegistry = registry;
    }

    public Packet addObject(Object test) {
        return this.addReference(this.myRegistry.referenceTo(test));
    }

    public Packet addReference(String reference) {
        this.appendString(reference + ':');
        return this;
    }

    public Packet switchInputTo(Object test) {
        this.appendString("I");
        return this.addObject(test);
    }

    public Packet addString(String string) {
        this.appendString(string);
        return this;
    }

    public void send() {
        this.sendThrough(this.myTransport);
    }

    public Packet addLong(long integer) {
        this.appendLong(integer);
        return this;
    }

    public Packet setTestState(Object test, int state) {
        return this.addString("S").addObject(test).addLong(state);
    }

    public Packet addLimitedString(String message) {
        this.appendLimitedString(message);
        return this;
    }

    public Packet addThrowable(Throwable throwable) {
        String filteredTrace = BaseTestRunner.getFilteredTrace((Throwable)throwable);
        String message = BaseTestRunner.getPreference((String)"filterstack").equals("true") ? Packet.makeNewLinesCompatibleWithJUnit(Packet.throwableToString(throwable)) : Packet.throwableToString(throwable);
        this.addLimitedString(message);
        if (filteredTrace.startsWith(message)) {
            filteredTrace = filteredTrace.substring(message.length());
        }
        this.addLimitedString(new TraceFilter(filteredTrace).execute());
        return this;
    }

    private static String throwableToString(Throwable throwable) {
        String tostring = throwable.toString();
        return tostring == null ? throwable.getClass().getName() : tostring;
    }

    private static String makeNewLinesCompatibleWithJUnit(String string) {
        try {
            String line;
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            BufferedReader reader = new BufferedReader(new StringReader(string));
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
            return buffer.getBuffer().toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String encode(String packet) {
        StringBuffer buffer = new StringBuffer(packet.length());
        for (int i = 0; i < packet.length(); ++i) {
            char chr = packet.charAt(i);
            if (chr == '$') {
                buffer.append(chr);
                buffer.append(chr);
                continue;
            }
            boolean appendChar = true;
            for (int j = 0; j < ourSymbolsToEncode.length; ++j) {
                if (ourSymbolsToEncode[j] != chr) continue;
                buffer.append('$');
                String code = String.valueOf((int)chr);
                for (int count = 2 - code.length(); count > 0; --count) {
                    buffer.append("0");
                }
                buffer.append(code);
                appendChar = false;
                break;
            }
            if (!appendChar) continue;
            buffer.append(chr);
        }
        return buffer.toString();
    }

    public Packet addStrings(Vector vector) {
        int size = vector.size();
        this.addLong(size);
        for (int i = 0; i < size; ++i) {
            this.addLimitedString((String)vector.elementAt(i));
        }
        return this;
    }
}

