/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MultiValuesMap<K, V> {
    private final Map<K, Collection<V>> myBaseMap;
    private final boolean myOrdered;

    public MultiValuesMap() {
        this(false);
    }

    public MultiValuesMap(boolean ordered) {
        this.myOrdered = ordered;
        this.myBaseMap = ordered ? new LinkedHashMap() : new HashMap();
    }

    public void putAll(K key, Collection<V> values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void putAll(K key, V ... values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void put(K key, V value) {
        if (!this.myBaseMap.containsKey(key)) {
            this.myBaseMap.put(key, this.myOrdered ? new LinkedHashSet() : new HashSet());
        }
        this.myBaseMap.get(key).add(value);
    }

    @Nullable
    public Collection<V> get(K key) {
        return this.myBaseMap.get(key);
    }

    public Set<K> keySet() {
        return this.myBaseMap.keySet();
    }

    public Collection<V> values() {
        HashSet result = this.myOrdered ? new LinkedHashSet() : new HashSet();
        for (Collection<V> values : this.myBaseMap.values()) {
            result.addAll(values);
        }
        return result;
    }

    public void remove(K key, V value) {
        if (!this.myBaseMap.containsKey(key)) {
            return;
        }
        Collection<V> values = this.myBaseMap.get(key);
        values.remove(value);
        if (values.isEmpty()) {
            this.myBaseMap.remove(key);
        }
    }

    public void clear() {
        this.myBaseMap.clear();
    }

    @Nullable
    public Collection<V> removeAll(K key) {
        return this.myBaseMap.remove(key);
    }

    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myBaseMap.entrySet();
    }

    public boolean isEmpty() {
        return this.myBaseMap.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.myBaseMap.containsKey(key);
    }

    public Collection<V> collectValues() {
        HashSet<V> result = new HashSet<V>();
        for (Collection<V> v : this.myBaseMap.values()) {
            result.addAll(v);
        }
        return result;
    }

    @Nullable
    public V getFirst(K key) {
        Collection<V> values = this.myBaseMap.get(key);
        return values == null || values.isEmpty() ? null : (V)values.iterator().next();
    }
}

